/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.io.StringWriter;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.common.AnalysisException;

public class Separator
implements ParseNode {
    private static final String HEX_STRING = "0123456789ABCDEF";
    private final String oriSeparator;
    private String separator;

    public Separator(String separator) {
        this.oriSeparator = separator;
        this.separator = null;
    }

    public String getOriSeparator() {
        return this.oriSeparator;
    }

    public String getSeparator() {
        return this.separator;
    }

    private static byte[] hexStrToBytes(String hexStr) {
        String upperHexStr = hexStr.toUpperCase();
        int length = upperHexStr.length() / 2;
        char[] hexChars = upperHexStr.toCharArray();
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            bytes[i] = (byte)(Separator.charToByte(hexChars[pos]) << 4 | Separator.charToByte(hexChars[pos + 1]));
        }
        return bytes;
    }

    private static byte charToByte(char c) {
        return (byte)HEX_STRING.indexOf(c);
    }

    public void analyze() throws AnalysisException {
        this.analyze(null);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.separator = Separator.convertSeparator(this.oriSeparator);
    }

    public static String convertSeparator(String originStr) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)originStr)) {
            throw new AnalysisException("Column separator is null or empty");
        }
        if (originStr.toUpperCase().startsWith("\\X")) {
            String hexStr = originStr.replaceAll("(?i)\\\\X", "");
            if (hexStr.isEmpty()) {
                throw new AnalysisException("Hex str is empty");
            }
            for (char hexChar : hexStr.toUpperCase().toCharArray()) {
                if (HEX_STRING.indexOf(hexChar) != -1) continue;
                throw new AnalysisException("Hex str format error");
            }
            if (hexStr.length() % 2 != 0) {
                throw new AnalysisException("Hex str length error");
            }
            StringWriter writer = new StringWriter();
            for (byte b : Separator.hexStrToBytes(hexStr)) {
                writer.append((char)b);
            }
            return writer.toString();
        }
        return Separator.unescape(originStr);
    }

    private static String unescape(String orig) {
        StringBuffer sb = new StringBuffer();
        boolean hadSlash = false;
        for (int i = 0; i < orig.length(); ++i) {
            char ch = orig.charAt(i);
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    default: {
                        sb.append('\\').append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                if (i == orig.length() - 1) {
                    sb.append(ch);
                    continue;
                }
                hadSlash = true;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("'").append(this.oriSeparator).append("'");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

