/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.AnalyticExpr;
import org.apache.doris.analysis.AnalyticInfo;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ArithmeticExpr;
import org.apache.doris.analysis.AssertNumRowsElement;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CaseExpr;
import org.apache.doris.analysis.DefaultValueExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FromClause;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.FunctionParams;
import org.apache.doris.analysis.GroupByClause;
import org.apache.doris.analysis.GroupingFunctionCallExpr;
import org.apache.doris.analysis.GroupingInfo;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.LateralViewRef;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SelectList;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SortInfo;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.ValueList;
import org.apache.doris.catalog.AggregateFunction;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.View;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ColumnAliasGenerator;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;
import org.apache.doris.common.TableAliasGenerator;
import org.apache.doris.common.TreeNode;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.SqlUtils;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SelectStmt
extends QueryStmt {
    private static final Logger LOG = LogManager.getLogger(SelectStmt.class);
    private UUID id = UUID.randomUUID();
    protected SelectList selectList;
    private final ArrayList<String> colLabels;
    protected final FromClause fromClause_;
    protected GroupByClause groupByClause;
    private List<Expr> originalExpr;
    private Expr havingClause;
    protected Expr whereClause;
    private Expr havingPred;
    private AggregateInfo aggInfo;
    private AnalyticInfo analyticInfo;
    private ExprSubstitutionMap baseTblSmap = new ExprSubstitutionMap();
    private ValueList valueList;
    private GroupingInfo groupingInfo;
    private Expr havingClauseAfterAnaylzed;
    protected String sqlString_;
    private TableAliasGenerator tableAliasGenerator = null;
    private SelectList originSelectList;
    private ColumnAliasGenerator columnAliasGenerator = null;

    public SelectStmt(ValueList valueList, ArrayList<OrderByElement> orderByElement, LimitElement limitElement) {
        super(orderByElement, limitElement);
        this.valueList = valueList;
        this.selectList = new SelectList();
        this.fromClause_ = new FromClause();
        this.colLabels = Lists.newArrayList();
    }

    SelectStmt(SelectList selectList, FromClause fromClause, Expr wherePredicate, GroupByClause groupByClause, Expr havingPredicate, ArrayList<OrderByElement> orderByElements, LimitElement limitElement) {
        super(orderByElements, limitElement);
        this.selectList = selectList;
        this.originSelectList = selectList.clone();
        this.fromClause_ = fromClause == null ? new FromClause() : fromClause;
        this.whereClause = wherePredicate;
        this.groupByClause = groupByClause;
        this.havingClause = havingPredicate;
        this.colLabels = Lists.newArrayList();
        this.havingPred = null;
        this.aggInfo = null;
        this.sortInfo = null;
        this.groupingInfo = null;
    }

    protected SelectStmt(SelectStmt other) {
        super(other);
        this.id = other.id;
        this.selectList = other.selectList.clone();
        this.fromClause_ = other.fromClause_.clone();
        this.whereClause = other.whereClause != null ? other.whereClause.clone() : null;
        this.groupByClause = other.groupByClause != null ? other.groupByClause.clone() : null;
        this.havingClause = other.havingClause != null ? other.havingClause.clone() : null;
        this.colLabels = Lists.newArrayList(other.colLabels);
        this.aggInfo = other.aggInfo != null ? other.aggInfo.clone() : null;
        this.analyticInfo = other.analyticInfo != null ? other.analyticInfo.clone() : null;
        this.sqlString_ = other.sqlString_ != null ? other.sqlString_ : null;
        this.baseTblSmap = other.baseTblSmap.clone();
        this.groupingInfo = null;
    }

    @Override
    public void reset() {
        super.reset();
        this.selectList.reset();
        this.colLabels.clear();
        this.fromClause_.reset();
        if (this.whereClause != null) {
            this.whereClause.reset();
        }
        if (this.groupByClause != null) {
            this.groupByClause.reset();
        }
        if (this.havingClause != null) {
            this.havingClause.reset();
        }
        this.havingClauseAfterAnaylzed = null;
        this.havingPred = null;
        this.aggInfo = null;
        this.analyticInfo = null;
        this.baseTblSmap.clear();
        this.groupingInfo = null;
    }

    @Override
    public void resetSelectList() {
        if (this.originSelectList != null) {
            this.selectList = this.originSelectList;
        }
    }

    @Override
    public QueryStmt clone() {
        return new SelectStmt(this);
    }

    public UUID getId() {
        return this.id;
    }

    public SelectList getSelectList() {
        return this.selectList;
    }

    public void setSelectList(SelectList selectList) {
        this.selectList = selectList;
    }

    public ValueList getValueList() {
        return this.valueList;
    }

    public Expr getHavingPred() {
        return this.havingPred;
    }

    public Expr getHavingClauseAfterAnaylzed() {
        return this.havingClauseAfterAnaylzed;
    }

    public List<TableRef> getTableRefs() {
        return this.fromClause_.getTableRefs();
    }

    public Expr getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(Expr whereClause) {
        this.whereClause = whereClause;
    }

    public AggregateInfo getAggInfo() {
        return this.aggInfo;
    }

    public GroupingInfo getGroupingInfo() {
        return this.groupingInfo;
    }

    public GroupByClause getGroupByClause() {
        return this.groupByClause;
    }

    public AnalyticInfo getAnalyticInfo() {
        return this.analyticInfo;
    }

    public boolean hasAnalyticInfo() {
        return this.analyticInfo != null;
    }

    public boolean hasHavingClause() {
        return this.havingClause != null;
    }

    public void removeHavingClause() {
        this.havingClause = null;
    }

    @Override
    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    @Override
    public ArrayList<String> getColLabels() {
        return this.colLabels;
    }

    public ExprSubstitutionMap getBaseTblSmap() {
        return this.baseTblSmap;
    }

    @Override
    public void getTables(Analyzer analyzer, Map<Long, Table> tableMap, Set<String> parentViewNameSet) throws AnalysisException {
        this.getWithClauseTables(analyzer, tableMap, parentViewNameSet);
        for (TableRef tblRef : this.fromClause_) {
            if (tblRef instanceof InlineViewRef) {
                QueryStmt inlineStmt = ((InlineViewRef)tblRef).getViewStmt();
                inlineStmt.getTables(analyzer, tableMap, parentViewNameSet);
                continue;
            }
            String dbName = tblRef.getName().getDb();
            String tableName = tblRef.getName().getTbl();
            dbName = Strings.isNullOrEmpty((String)dbName) ? analyzer.getDefaultDb() : ClusterNamespace.getFullName(analyzer.getClusterName(), tblRef.getName().getDb());
            if (this.isViewTableRef(tblRef.getName().toString(), parentViewNameSet)) continue;
            if (Strings.isNullOrEmpty((String)dbName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            if (Strings.isNullOrEmpty((String)tableName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_TABLE, tableName, dbName);
            }
            Database db = analyzer.getCatalog().getDbOrAnalysisException(dbName);
            Table table = db.getTableOrAnalysisException(tableName);
            if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tableName, PrivPredicate.SELECT)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SELECT", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + tableName);
            }
            tableMap.put(table.getId(), table);
        }
    }

    @Override
    public void getTableRefs(Analyzer analyzer, List<TableRef> tblRefs, Set<String> parentViewNameSet) {
        this.getWithClauseTableRefs(analyzer, tblRefs, parentViewNameSet);
        for (TableRef tblRef : this.fromClause_) {
            try {
                TableRef tmpTblRef = analyzer.resolveTableRef(tblRef);
                if (tmpTblRef instanceof InlineViewRef) {
                    QueryStmt inlineStmt = ((InlineViewRef)tmpTblRef).getViewStmt();
                    inlineStmt.getTableRefs(analyzer, tblRefs, parentViewNameSet);
                    continue;
                }
                if (this.isViewTableRef(tmpTblRef.getName().toString(), parentViewNameSet)) continue;
                tblRefs.add(tmpTblRef);
            }
            catch (AnalysisException analysisException) {}
        }
    }

    private boolean isViewTableRef(String tblName, Set<String> parentViewNameSet) {
        if (parentViewNameSet.contains(tblName)) {
            return true;
        }
        if (this.withClause_ != null) {
            List<View> views = this.withClause_.getViews();
            for (View view : views) {
                if (!view.getName().equals(tblName)) continue;
                return true;
            }
        }
        return false;
    }

    public ColumnAliasGenerator getColumnAliasGenerator() {
        if (this.columnAliasGenerator == null) {
            this.columnAliasGenerator = new ColumnAliasGenerator(this.colLabels, null);
        }
        return this.columnAliasGenerator;
    }

    public TableAliasGenerator getTableAliasGenerator() {
        if (this.tableAliasGenerator == null) {
            this.tableAliasGenerator = new TableAliasGenerator(this.analyzer, null);
        }
        return this.tableAliasGenerator;
    }

    public void setTableAliasGenerator(TableAliasGenerator tableAliasGenerator) {
        this.tableAliasGenerator = tableAliasGenerator;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        this.fromClause_.setNeedToSql(this.needToSql);
        this.fromClause_.analyze(analyzer);
        if (!analyzer.isWithClause()) {
            this.registerIsNotEmptyPredicates(analyzer);
        }
        for (SelectListItem item2 : this.selectList.getItems()) {
            if (item2.isStar()) {
                TableName tblName = item2.getTblName();
                if (tblName == null) {
                    this.expandStar(analyzer);
                    continue;
                }
                this.expandStar(analyzer, tblName);
                continue;
            }
            item2.getExpr().analyze(analyzer);
            if (!(item2.getExpr() instanceof CaseExpr) && item2.getExpr().contains(Predicates.instanceOf(Subquery.class))) {
                throw new AnalysisException("Subquery is not supported in the select list.");
            }
            Expr expr = this.rewriteQueryExprByMvColumnExpr(item2.getExpr(), analyzer);
            this.resultExprs.add(expr);
            SlotRef aliasRef = new SlotRef(null, item2.toColumnLabel());
            Expr existingAliasExpr = this.aliasSMap.get(aliasRef);
            if (existingAliasExpr != null && !existingAliasExpr.equals(item2.getExpr())) {
                this.ambiguousAliasList.add(aliasRef);
            }
            this.aliasSMap.put(aliasRef, item2.getExpr().clone());
            this.colLabels.add(item2.toColumnLabel());
        }
        if (this.groupByClause != null && this.groupByClause.isGroupByExtension()) {
            for (SelectListItem item2 : this.selectList.getItems()) {
                if (!(item2.getExpr() instanceof FunctionCallExpr) || !(item2.getExpr().fn instanceof AggregateFunction)) continue;
                for (Expr expr : this.groupByClause.getGroupingExprs()) {
                    if (!item2.getExpr().contains(expr)) continue;
                    throw new AnalysisException("column: " + expr.toSql() + " cannot both in select list and aggregate functions when using GROUPING SETS/CUBE/ROLLUP, please use union instead.");
                }
            }
            this.groupingInfo = new GroupingInfo(analyzer, this.groupByClause);
            this.groupingInfo.substituteGroupingFn(this.resultExprs, analyzer);
        } else {
            for (Expr expr : this.resultExprs) {
                if (!this.checkGroupingFn(expr)) continue;
                throw new AnalysisException("cannot use GROUPING functions without [grouping sets|rollup|cube] clause or grouping sets only have one element.");
            }
        }
        if (this.valueList != null) {
            if (!this.fromInsert) {
                this.valueList.analyzeForSelect(analyzer);
            }
            for (Expr expr : this.valueList.getFirstRow()) {
                if (expr instanceof DefaultValueExpr) {
                    this.resultExprs.add(new IntLiteral(1L));
                } else {
                    this.resultExprs.add(expr);
                }
                this.colLabels.add(expr.toColumnLabel());
            }
        }
        if (this.needToSql) {
            this.originalExpr = Expr.cloneList(this.resultExprs);
        }
        Expr.analyze(this.resultExprs, analyzer);
        if (TreeNode.contains(this.resultExprs, AnalyticExpr.class)) {
            if (this.fromClause_.isEmpty()) {
                throw new AnalysisException("Analytic expressions require FROM clause.");
            }
            if (this.selectList.isDistinct()) {
                throw new AnalysisException("cannot combine SELECT DISTINCT with analytic functions");
            }
        }
        this.whereClauseRewrite();
        if (this.whereClause != null) {
            if (this.checkGroupingFn(this.whereClause)) {
                throw new AnalysisException("grouping operations are not allowed in WHERE.");
            }
            this.whereClause.analyze(analyzer);
            if (this.whereClause.containsAggregate()) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_INVALID_GROUP_FUNC_USE, new Object[0]);
            }
            this.whereClause.checkReturnsBool("WHERE clause", false);
            Expr e = this.whereClause.findFirstOf(AnalyticExpr.class);
            if (e != null) {
                throw new AnalysisException("WHERE clause must not contain analytic expressions: " + e.toSql());
            }
            analyzer.registerConjuncts(this.whereClause, false, this.getTableRefIds());
        }
        if (VectorizedUtil.isVectorized()) {
            analyzer.changeAllOuterJoinTupleToNull();
        }
        this.createSortInfo(analyzer);
        if (this.sortInfo != null && CollectionUtils.isNotEmpty(this.sortInfo.getOrderingExprs()) && this.groupingInfo != null) {
            List<Expr> orderingExprNotInSelect = this.sortInfo.getOrderingExprs().stream().filter(item -> !this.resultExprs.contains(item)).collect(Collectors.toList());
            this.groupingInfo.substituteGroupingFn(orderingExprNotInSelect, analyzer);
        }
        this.analyzeAggregation(analyzer);
        this.createAnalyticInfo(analyzer);
        if (this.evaluateOrderBy) {
            this.createSortTupleInfo(analyzer);
        }
        if (this.needToSql) {
            this.sqlString_ = this.toSql();
        }
        if (analyzer.enableStarJoinReorder()) {
            LOG.debug("use old reorder logical in select stmt");
            this.reorderTable(analyzer);
        }
        this.resolveInlineViewRefs(analyzer);
        if (analyzer.hasEmptySpjResultSet() && this.aggInfo == null) {
            analyzer.setHasEmptyResultSet();
        }
        if (this.aggInfo != null && LOG.isDebugEnabled()) {
            LOG.debug("post-analysis " + this.aggInfo.debugString());
        }
        if (this.hasOutFileClause()) {
            this.outFileClause.analyze(analyzer, this.resultExprs);
        }
    }

    public List<TupleId> getTableRefIds() {
        ArrayList result = Lists.newArrayList();
        for (TableRef ref : this.fromClause_) {
            result.add(ref.getId());
        }
        return result;
    }

    public List<TupleId> getTableRefIdsWithoutInlineView() {
        ArrayList result = Lists.newArrayList();
        for (TableRef ref : this.fromClause_) {
            if (ref instanceof InlineViewRef) continue;
            result.add(ref.getId());
        }
        return result;
    }

    public boolean hasInlineView() {
        for (TableRef ref : this.fromClause_) {
            if (!(ref instanceof InlineViewRef)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<TupleId> collectTupleIds() {
        ArrayList result = Lists.newArrayList();
        this.resultExprs.stream().forEach(expr -> expr.getIds(result, null));
        result.addAll(this.getTableRefIds());
        if (this.whereClause != null) {
            this.whereClause.getIds(result, null);
        }
        if (this.havingClauseAfterAnaylzed != null) {
            this.havingClauseAfterAnaylzed.getIds(result, null);
        }
        return result;
    }

    private void whereClauseRewrite() {
        if (this.whereClause instanceof IntLiteral) {
            this.whereClause = ((IntLiteral)this.whereClause).getLongValue() == 0L ? new BoolLiteral(false) : new BoolLiteral(true);
        }
    }

    private void registerIsNotEmptyPredicates(Analyzer analyzer) throws AnalysisException {
    }

    @Override
    public void materializeRequiredSlots(Analyzer analyzer) throws AnalysisException {
        List<Expr> unassigned = analyzer.getUnassignedConjuncts(this.getTableRefIds(), true);
        ArrayList unassignedJoinConjuncts = Lists.newArrayList();
        for (Expr e : unassigned) {
            if (!analyzer.evalAfterJoin(e)) continue;
            unassignedJoinConjuncts.add(e);
        }
        ArrayList<Expr> baseTblJoinConjuncts = Expr.trySubstituteList(unassignedJoinConjuncts, this.baseTblSmap, analyzer, false);
        analyzer.materializeSlots(baseTblJoinConjuncts);
        if (this.evaluateOrderBy) {
            this.sortInfo.materializeRequiredSlots(analyzer, this.baseTblSmap);
        }
        if (this.hasAnalyticInfo()) {
            ArrayList tids = Lists.newArrayList();
            this.getMaterializedTupleIds(tids);
            List<Expr> conjuncts = analyzer.getUnassignedConjuncts(tids);
            analyzer.materializeSlots(conjuncts);
            this.analyticInfo.materializeRequiredSlots(analyzer, this.baseTblSmap);
        }
        if (this.aggInfo != null) {
            ArrayList havingConjuncts = Lists.newArrayList();
            if (this.havingPred != null) {
                havingConjuncts.add(this.havingPred);
            }
            havingConjuncts.addAll(analyzer.getUnassignedConjuncts(this.aggInfo.getResultTupleId().asList()));
            this.materializeSlots(analyzer, havingConjuncts);
            this.aggInfo.materializeRequiredSlots(analyzer, this.baseTblSmap);
        }
        for (TableRef tableRef : this.fromClause_.getTableRefs()) {
            if (tableRef.lateralViewRefs == null) continue;
            for (LateralViewRef lateralViewRef : tableRef.lateralViewRefs) {
                lateralViewRef.materializeRequiredSlots(this.baseTblSmap, analyzer);
            }
        }
    }

    protected void reorderTable(Analyzer analyzer) throws AnalysisException {
        ArrayList candidates = Lists.newArrayList();
        ArrayList originOrderBackUp = Lists.newArrayList(this.fromClause_.getTableRefs());
        for (TableRef tblRef : this.fromClause_) {
            if (tblRef.getJoinOp() != JoinOperator.INNER_JOIN || tblRef.hasJoinHints()) {
                return;
            }
            long rowCount = 0L;
            if (tblRef.getTable().getType() == Table.TableType.OLAP) {
                rowCount = ((OlapTable)tblRef.getTable()).getRowCount();
                LOG.debug("tableName={} rowCount={}", (Object)tblRef.getAlias(), (Object)rowCount);
            }
            candidates.add(new Pair<TableRef, Long>(tblRef, rowCount));
        }
        long last = 0L;
        for (int i = candidates.size() - 1; i >= 0; --i) {
            Pair candidate = (Pair)candidates.get(i);
            if (candidate.first instanceof InlineViewRef) {
                candidate.second = last;
            }
            last = (Long)candidate.second + 1L;
        }
        Collections.sort(candidates, (a, b) -> ((Long)b.second).compareTo((Long)a.second));
        for (Pair candidate : candidates) {
            if (!this.reorderTable(analyzer, (TableRef)candidate.first)) continue;
            return;
        }
        this.fromClause_.clear();
        for (TableRef tableRef : originOrderBackUp) {
            this.fromClause_.add(tableRef);
        }
    }

    protected boolean reorderTable(Analyzer analyzer, TableRef firstRef) throws AnalysisException {
        ArrayList tmpRefList = Lists.newArrayList();
        HashMap tableRefMap = Maps.newHashMap();
        for (TableRef tblRef : this.fromClause_) {
            tableRefMap.put(tblRef.getId(), tblRef);
            tmpRefList.add(tblRef);
        }
        this.fromClause_.clear();
        this.fromClause_.add(firstRef);
        tableRefMap.remove(firstRef.getId());
        HashSet validTupleId = Sets.newHashSet();
        validTupleId.add(firstRef.getId());
        for (int i = 0; i < this.fromClause_.size(); ++i) {
            TableRef tblRef = this.fromClause_.get(i);
            List<Expr> eqJoinPredicates = analyzer.getEqJoinConjuncts(tblRef.getId());
            ArrayList tuple_list = Lists.newArrayList();
            Expr.getIds(eqJoinPredicates, tuple_list, null);
            block2: for (TupleId tid : tuple_list) {
                TableRef candidateTableRef;
                if (validTupleId.contains(tid) || (candidateTableRef = (TableRef)tableRefMap.get(tid)) == null) continue;
                Preconditions.checkState((tid == candidateTableRef.getId() ? 1 : 0) != 0);
                List<Expr> candidateEqJoinPredicates = analyzer.getEqJoinConjunctsExcludeAuxPredicates(tid);
                for (Expr candidateEqJoinPredicate : candidateEqJoinPredicates) {
                    ArrayList candidateTupleList = Lists.newArrayList();
                    ArrayList candidateEqJoinPredicateList = Lists.newArrayList((Object[])new Expr[]{candidateEqJoinPredicate});
                    if (candidateTableRef.getOnClause() != null) {
                        candidateEqJoinPredicateList.add(candidateTableRef.getOnClause());
                    }
                    Expr.getIds(candidateEqJoinPredicateList, candidateTupleList, null);
                    int count = candidateTupleList.size();
                    for (TupleId tupleId : candidateTupleList) {
                        if (!validTupleId.contains(tupleId) && !tid.equals(tupleId)) continue;
                        --count;
                    }
                    if (count != 0) continue;
                    this.fromClause_.add(candidateTableRef);
                    validTupleId.add(tid);
                    tableRefMap.remove(tid);
                    continue block2;
                }
            }
        }
        if (0 != tableRefMap.size()) {
            this.fromClause_.clear();
            this.fromClause_.addAll(tmpRefList);
            return false;
        }
        return true;
    }

    protected void resolveInlineViewRefs(Analyzer analyzer) throws AnalysisException {
        for (TableRef tblRef : this.fromClause_) {
            if (!(tblRef instanceof InlineViewRef)) continue;
            InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
            this.baseTblSmap = ExprSubstitutionMap.combine(this.baseTblSmap, inlineViewRef.getBaseTblSmap());
        }
        this.baseTblResultExprs = Expr.trySubstituteList(this.resultExprs, this.baseTblSmap, analyzer, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("baseTblSmap_: " + this.baseTblSmap.debugString());
            LOG.debug("resultExprs: " + Expr.debugString(this.resultExprs));
            LOG.debug("baseTblResultExprs: " + Expr.debugString(this.baseTblResultExprs));
        }
    }

    private void expandStar(Analyzer analyzer) throws AnalysisException {
        if (this.fromClause_.isEmpty()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_TABLES_USED, new Object[0]);
        }
        for (TableRef tableRef : this.fromClause_) {
            if (analyzer.isSemiJoined(tableRef.getId())) continue;
            this.expandStar(new TableName(tableRef.getAliasAsName().getDb(), tableRef.getAliasAsName().getTbl()), tableRef.getDesc());
            if (tableRef.lateralViewRefs == null) continue;
            for (LateralViewRef lateralViewRef : tableRef.lateralViewRefs) {
                this.expandStar(lateralViewRef.getName(), lateralViewRef.getDesc());
            }
        }
    }

    private void expandStar(Analyzer analyzer, TableName tblName) throws AnalysisException {
        Collection<TupleDescriptor> descs = analyzer.getDescriptor(tblName);
        if (descs == null || descs.isEmpty()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_TABLE, tblName.getTbl(), tblName.getDb());
        }
        for (TupleDescriptor desc : descs) {
            this.expandStar(tblName, desc);
        }
    }

    private void expandStar(TableName tblName, TupleDescriptor desc) {
        for (Column col : desc.getTable().getBaseSchema()) {
            this.resultExprs.add(new SlotRef(tblName, col.getName()));
            this.colLabels.add(col.getName());
        }
    }

    private void analyzeAggregation(Analyzer analyzer) throws AnalysisException {
        int i;
        if (this.havingClause != null) {
            Expr ambiguousAlias = this.getFirstAmbiguousAlias(this.havingClause);
            if (ambiguousAlias != null) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NON_UNIQ_ERROR, ambiguousAlias.toColumnLabel());
            }
            this.havingClauseAfterAnaylzed = this.havingClause.substitute(this.aliasSMap, analyzer, false);
            this.havingClauseAfterAnaylzed = this.rewriteQueryExprByMvColumnExpr(this.havingClauseAfterAnaylzed, analyzer);
            this.havingClauseAfterAnaylzed.checkReturnsBool("HAVING clause", true);
            Expr analyticExpr = this.havingClauseAfterAnaylzed.findFirstOf(AnalyticExpr.class);
            if (analyticExpr != null) {
                throw new AnalysisException("HAVING clause must not contain analytic expressions: " + analyticExpr.toSql());
            }
        }
        if (!(this.groupByClause != null || this.selectList.isDistinct() || TreeNode.contains(this.resultExprs, Expr.isAggregatePredicate()) || this.havingClauseAfterAnaylzed != null && this.havingClauseAfterAnaylzed.contains(Expr.isAggregatePredicate()) || this.sortInfo != null && TreeNode.contains(this.sortInfo.getOrderingExprs(), Expr.isAggregatePredicate()))) {
            if (this.havingClauseAfterAnaylzed != null) {
                if (this.havingClauseAfterAnaylzed.contains(Subquery.class)) {
                    throw new AnalysisException("Only constant expr could be supported in having clause when no aggregation in stmt");
                }
                analyzer.registerConjuncts(this.havingClauseAfterAnaylzed, true);
            }
            return;
        }
        if (this.fromClause_.size() == 0) {
            throw new AnalysisException("Aggregation without a FROM clause is not allowed");
        }
        if (this.selectList.isDistinct() && this.groupByClause == null) {
            ArrayList aggregateExpr = Lists.newArrayList();
            TreeNode.collect(this.resultExprs, Expr.isAggregatePredicate(), aggregateExpr);
            if (aggregateExpr.size() == this.resultExprs.size()) {
                this.selectList.setIsDistinct(false);
            }
        }
        if (this.selectList.isDistinct() && (this.groupByClause != null || TreeNode.contains(this.resultExprs, Expr.isAggregatePredicate()) || this.havingClauseAfterAnaylzed != null && this.havingClauseAfterAnaylzed.contains(Expr.isAggregatePredicate()))) {
            throw new AnalysisException("cannot combine SELECT DISTINCT with aggregate functions or GROUP BY");
        }
        if (this.groupByClause != null || TreeNode.contains(this.resultExprs, Expr.isAggregatePredicate())) {
            for (SelectListItem item : this.selectList.getItems()) {
                if (!item.isStar()) continue;
                throw new AnalysisException("cannot combine '*' in select list with GROUP BY: " + item.toSql());
            }
        }
        ArrayList aggExprs = Lists.newArrayList();
        TreeNode.collect(this.resultExprs, Expr.isAggregatePredicate(), aggExprs);
        if (this.havingClauseAfterAnaylzed != null) {
            this.havingClauseAfterAnaylzed.collect(Expr.isAggregatePredicate(), aggExprs);
        }
        if (this.sortInfo != null) {
            TreeNode.collect(this.sortInfo.getOrderingExprs(), Expr.isAggregatePredicate(), aggExprs);
        }
        ExprSubstitutionMap countAllMap = this.createCountAllMap(aggExprs, analyzer);
        ExprSubstitutionMap multiCountOrSumDistinctMap = this.createSumOrCountMultiDistinctSMap(aggExprs, analyzer);
        countAllMap = ExprSubstitutionMap.compose(multiCountOrSumDistinctMap, countAllMap, analyzer);
        ArrayList<Expr> substitutedAggs = Expr.substituteList(aggExprs, countAllMap, analyzer, false);
        aggExprs.clear();
        TreeNode.collect(substitutedAggs, Expr.isAggregatePredicate(), aggExprs);
        ArrayList<TupleId> groupingByTupleIds = new ArrayList<TupleId>();
        if (this.groupByClause != null) {
            if (this.groupingInfo != null) {
                groupingByTupleIds.add(this.groupingInfo.getVirtualTuple().getId());
            }
            this.groupByClause.genGroupingExprs();
            if (this.groupingInfo != null) {
                GroupByClause.GroupingType groupingType = this.groupByClause.getGroupingType();
                if (groupingType == GroupByClause.GroupingType.GROUPING_SETS && CollectionUtils.isNotEmpty(this.groupByClause.getGroupingSetList()) || groupingType == GroupByClause.GroupingType.CUBE || groupingType == GroupByClause.GroupingType.ROLLUP) {
                    // empty if block
                }
                this.groupingInfo.buildRepeat(this.groupByClause.getGroupingExprs(), this.groupByClause.getGroupingSetList());
            }
            this.substituteOrdinalsAliases(this.groupByClause.getGroupingExprs(), "GROUP BY", analyzer);
            this.groupByClause.analyze(analyzer);
            this.createAggInfo(this.groupByClause.getGroupingExprs(), aggExprs, analyzer);
        } else {
            this.createAggInfo(new ArrayList<Expr>(), aggExprs, analyzer);
        }
        AggregateInfo finalAggInfo = this.aggInfo.getSecondPhaseDistinctAggInfo() != null ? this.aggInfo.getSecondPhaseDistinctAggInfo() : this.aggInfo;
        groupingByTupleIds.add(finalAggInfo.getOutputTupleId());
        ExprSubstitutionMap combinedSmap = ExprSubstitutionMap.compose(countAllMap, finalAggInfo.getOutputSmap(), analyzer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("combined smap: " + combinedSmap.debugString());
            LOG.debug("desctbl: " + analyzer.getDescTbl().debugString());
            LOG.debug("resultexprs: " + Expr.debugString(this.resultExprs));
        }
        if (this.havingClauseAfterAnaylzed != null) {
            ArrayList subqueryInHaving = Lists.newArrayList();
            this.havingClauseAfterAnaylzed.collect(Subquery.class, subqueryInHaving);
            for (Subquery subquery : subqueryInHaving) {
                if (!subquery.isCorrelatedPredicate(this.getTableRefIds())) continue;
                throw new AnalysisException("The correlated having clause is not supported");
            }
        }
        this.resultExprs = Expr.substituteList(this.resultExprs, combinedSmap, analyzer, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("post-agg selectListExprs: " + Expr.debugString(this.resultExprs));
        }
        if (this.havingClauseAfterAnaylzed != null) {
            this.havingPred = this.havingClauseAfterAnaylzed.substitute(combinedSmap, analyzer, false);
            analyzer.registerConjuncts(this.havingPred, true, finalAggInfo.getOutputTupleId().asList());
            if (LOG.isDebugEnabled()) {
                LOG.debug("post-agg havingPred: " + this.havingPred.debugString());
            }
        }
        if (this.sortInfo != null) {
            this.sortInfo.substituteOrderingExprs(combinedSmap, analyzer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("post-agg orderingExprs: " + Expr.debugString(this.sortInfo.getOrderingExprs()));
            }
        }
        for (i = 0; i < this.selectList.getItems().size(); ++i) {
            if (((Expr)this.resultExprs.get(i)).isBoundByTupleIds(groupingByTupleIds)) continue;
            throw new AnalysisException("select list expression not produced by aggregation output (missing from GROUP BY clause?): " + this.selectList.getItems().get(i).getExpr().toSql());
        }
        if (this.orderByElements != null) {
            for (i = 0; i < this.orderByElements.size(); ++i) {
                if (!this.sortInfo.getOrderingExprs().get(i).isBoundByTupleIds(groupingByTupleIds)) {
                    throw new AnalysisException("ORDER BY expression not produced by aggregation output (missing from GROUP BY clause?): " + ((OrderByElement)this.orderByElements.get(i)).getExpr().toSql());
                }
                if (this.sortInfo.getOrderingExprs().get((int)i).type.isHllType()) {
                    throw new AnalysisException("ORDER BY expression could not contain hll column.");
                }
                if (!this.sortInfo.getOrderingExprs().get((int)i).type.isBitmapType()) continue;
                throw new AnalysisException("ORDER BY expression could not contain bitmap column.");
            }
        }
        if (this.havingPred != null && !this.havingPred.isBoundByTupleIds(groupingByTupleIds)) {
            throw new AnalysisException("HAVING clause not produced by aggregation output (missing from GROUP BY clause?): " + this.havingClause.toSql());
        }
    }

    private ExprSubstitutionMap createSumOrCountMultiDistinctSMap(ArrayList<FunctionCallExpr> aggExprs, Analyzer analyzer) throws AnalysisException {
        ArrayList distinctExprs = Lists.newArrayList();
        for (FunctionCallExpr aggExpr : aggExprs) {
            if (!aggExpr.isDistinct()) continue;
            distinctExprs.add(aggExpr);
        }
        ExprSubstitutionMap result = new ExprSubstitutionMap();
        boolean hasMultiDistinct = AggregateInfo.estimateIfContainsMultiDistinct(distinctExprs);
        if (!hasMultiDistinct) {
            return result;
        }
        for (FunctionCallExpr inputExpr : distinctExprs) {
            ArrayList sumInputExprs;
            Expr replaceExpr = null;
            String functionName = inputExpr.getFnName().getFunction();
            if (functionName.equalsIgnoreCase("count")) {
                ArrayList countInputExpr = Lists.newArrayList((Object[])new Expr[]{((Expr)inputExpr.getChild(0)).clone(null)});
                replaceExpr = new FunctionCallExpr("MULTI_DISTINCT_COUNT", new FunctionParams(inputExpr.isDistinct(), countInputExpr));
            } else if (functionName.equalsIgnoreCase("SUM")) {
                sumInputExprs = Lists.newArrayList((Object[])new Expr[]{((Expr)inputExpr.getChild(0)).clone(null)});
                replaceExpr = new FunctionCallExpr("MULTI_DISTINCT_SUM", new FunctionParams(inputExpr.isDistinct(), sumInputExprs));
            } else if (functionName.equalsIgnoreCase("AVG")) {
                sumInputExprs = Lists.newArrayList((Object[])new Expr[]{((Expr)inputExpr.getChild(0)).clone(null)});
                ArrayList countInputExpr = Lists.newArrayList((Object[])new Expr[]{((Expr)inputExpr.getChild(0)).clone(null)});
                FunctionCallExpr sumExpr = new FunctionCallExpr("MULTI_DISTINCT_SUM", new FunctionParams(inputExpr.isDistinct(), sumInputExprs));
                FunctionCallExpr countExpr = new FunctionCallExpr("MULTI_DISTINCT_COUNT", new FunctionParams(inputExpr.isDistinct(), countInputExpr));
                replaceExpr = new ArithmeticExpr(ArithmeticExpr.Operator.DIVIDE, sumExpr, countExpr);
            } else {
                throw new AnalysisException(inputExpr.getFnName() + " can't support multi distinct.");
            }
            replaceExpr.analyze(analyzer);
            result.put(inputExpr, replaceExpr);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("multi distinct smap: {}", (Object)result.debugString());
        }
        return result;
    }

    private ExprSubstitutionMap createCountAllMap(List<FunctionCallExpr> aggExprs, Analyzer analyzer) throws AnalysisException {
        ExprSubstitutionMap scalarCountAllMap = new ExprSubstitutionMap();
        if (this.groupByClause != null && !this.groupByClause.isEmpty()) {
            return scalarCountAllMap;
        }
        Predicate<FunctionCallExpr> isNotDistinctPred = new Predicate<FunctionCallExpr>(){

            public boolean apply(FunctionCallExpr expr) {
                return !expr.isDistinct();
            }
        };
        if (Iterables.all(aggExprs, (Predicate)isNotDistinctPred)) {
            return scalarCountAllMap;
        }
        Predicate<FunctionCallExpr> isCountPred = new Predicate<FunctionCallExpr>(){

            public boolean apply(FunctionCallExpr expr) {
                return expr.getFnName().getFunction().equals("count");
            }
        };
        Iterable countAllAggs = Iterables.filter(aggExprs, (Predicate)Predicates.and((Predicate)isCountPred, (Predicate)isNotDistinctPred));
        for (FunctionCallExpr countAllAgg : countAllAggs) {
            ArrayList zeroIfNullParam = Lists.newArrayList((Object[])new Expr[]{countAllAgg.clone(), new IntLiteral(0L, (Type)Type.BIGINT)});
            FunctionCallExpr zeroIfNull = new FunctionCallExpr("ifnull", (List<Expr>)zeroIfNullParam);
            zeroIfNull.analyze(analyzer);
            scalarCountAllMap.put(countAllAgg, zeroIfNull);
        }
        return scalarCountAllMap;
    }

    private void createAggInfo(ArrayList<Expr> groupingExprs, ArrayList<FunctionCallExpr> aggExprs, Analyzer analyzer) throws AnalysisException {
        if (this.selectList.isDistinct()) {
            Preconditions.checkState((boolean)groupingExprs.isEmpty());
            Preconditions.checkState((boolean)aggExprs.isEmpty());
            this.aggInfo = AggregateInfo.create(Expr.cloneList(this.resultExprs), null, null, analyzer);
        } else {
            this.aggInfo = AggregateInfo.create(groupingExprs, aggExprs, null, analyzer);
        }
    }

    private void createAnalyticInfo(Analyzer analyzer) throws AnalysisException {
        ArrayList analyticExprs = Lists.newArrayList();
        TreeNode.collect(this.resultExprs, AnalyticExpr.class, analyticExprs);
        if (this.sortInfo != null) {
            TreeNode.collect(this.sortInfo.getOrderingExprs(), AnalyticExpr.class, analyticExprs);
        }
        if (analyticExprs.isEmpty()) {
            return;
        }
        ExprSubstitutionMap rewriteSmap = new ExprSubstitutionMap();
        for (Expr expr : analyticExprs) {
            AnalyticExpr toRewrite = (AnalyticExpr)expr;
            Expr newExpr = AnalyticExpr.rewrite(toRewrite);
            if (newExpr == null) continue;
            newExpr.analyze(analyzer);
            if (rewriteSmap.containsMappingFor(toRewrite)) continue;
            rewriteSmap.put(toRewrite, newExpr);
        }
        if (rewriteSmap.size() > 0) {
            ArrayList<Expr> updatedAnalyticExprs = Expr.substituteList(analyticExprs, rewriteSmap, analyzer, false);
            analyticExprs.clear();
            TreeNode.collect(updatedAnalyticExprs, AnalyticExpr.class, analyticExprs);
        }
        this.analyticInfo = AnalyticInfo.create(analyticExprs, analyzer);
        ExprSubstitutionMap smap = this.analyticInfo.getSmap();
        if (rewriteSmap.size() > 0) {
            smap = ExprSubstitutionMap.compose(rewriteSmap, this.analyticInfo.getSmap(), analyzer);
        }
        this.resultExprs = Expr.substituteList(this.resultExprs, smap, analyzer, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug("post-analytic selectListExprs: " + Expr.debugString(this.resultExprs));
        }
        if (this.sortInfo != null) {
            this.sortInfo.substituteOrderingExprs(smap, analyzer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("post-analytic orderingExprs: " + Expr.debugString(this.sortInfo.getOrderingExprs()));
            }
        }
    }

    @Override
    public void rewriteExprs(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        this.rewriteSelectList(rewriter);
        for (Object ref : this.fromClause_) {
            ((TableRef)ref).rewriteExprs(rewriter, this.analyzer);
        }
        ArrayList subqueryExprs = Lists.newArrayList();
        if (this.whereClause != null) {
            this.whereClause = rewriter.rewrite(this.whereClause, this.analyzer, ExprRewriter.ClauseType.WHERE_CLAUSE);
            this.whereClause.collect(Subquery.class, subqueryExprs);
        }
        if (this.havingClause != null) {
            this.havingClause = rewriter.rewrite(this.havingClause, this.analyzer);
            this.havingClauseAfterAnaylzed.collect(Subquery.class, subqueryExprs);
        }
        for (Subquery subquery : subqueryExprs) {
            subquery.getStatement().rewriteExprs(rewriter);
        }
        if (this.groupByClause != null) {
            List<Expr> oriGroupingExprs;
            ArrayList<Expr> groupingExprs = this.groupByClause.getGroupingExprs();
            if (groupingExprs != null) {
                rewriter.rewriteList(groupingExprs, this.analyzer);
            }
            if ((oriGroupingExprs = this.groupByClause.getOriGroupingExprs()) != null) {
                rewriter.rewriteList(oriGroupingExprs, this.analyzer);
            }
        }
        if (this.orderByElements != null) {
            for (OrderByElement orderByElem : this.orderByElements) {
                orderByElem.setExpr(rewriter.rewrite(orderByElem.getExpr(), this.analyzer));
            }
        }
    }

    @Override
    public void collectExprs(Map<String, Expr> exprMap) {
        ArrayList subqueryExprs = Lists.newArrayList();
        for (SelectListItem item : this.selectList.getItems()) {
            if (item.isStar()) continue;
            this.registerExprId(item.getExpr());
            exprMap.put(item.getExpr().getId().toString(), item.getExpr());
            if (!item.getExpr().contains(Predicates.instanceOf(Subquery.class))) continue;
            item.getExpr().collect(Subquery.class, subqueryExprs);
        }
        for (TableRef ref : this.fromClause_) {
            Preconditions.checkState((boolean)ref.isAnalyzed);
            if (ref.onClause != null) {
                this.registerExprId(ref.onClause);
                exprMap.put(ref.onClause.getId().toString(), ref.onClause);
            }
            if (!(ref instanceof InlineViewRef)) continue;
            ((InlineViewRef)ref).getViewStmt().collectExprs(exprMap);
        }
        if (this.whereClause != null) {
            this.registerExprId(this.whereClause);
            exprMap.put(this.whereClause.getId().toString(), this.whereClause);
            this.whereClause.collect(Subquery.class, subqueryExprs);
        }
        if (this.havingClause != null) {
            this.registerExprId(this.havingClauseAfterAnaylzed);
            exprMap.put(this.havingClauseAfterAnaylzed.getId().toString(), this.havingClauseAfterAnaylzed);
            this.havingClauseAfterAnaylzed.collect(Subquery.class, subqueryExprs);
        }
        for (Object subquery : subqueryExprs) {
            this.registerExprId((Expr)subquery);
            ((Subquery)subquery).getStatement().collectExprs(exprMap);
        }
        if (this.groupByClause != null) {
            List<Expr> oriGroupingExprs;
            ArrayList<Expr> groupingExprs = this.groupByClause.getGroupingExprs();
            if (groupingExprs != null) {
                for (Expr expr : groupingExprs) {
                    if (this.containAlias(expr)) continue;
                    this.registerExprId(expr);
                    exprMap.put(expr.getId().toString(), expr);
                }
            }
            if ((oriGroupingExprs = this.groupByClause.getOriGroupingExprs()) != null) {
                for (Expr expr : oriGroupingExprs) {
                    if (this.containAlias(expr)) continue;
                    this.registerExprId(expr);
                    exprMap.put(expr.getId().toString(), expr);
                }
            }
        }
        if (this.orderByElements != null) {
            for (OrderByElement orderByElem : this.orderByElements) {
                if (this.containAlias(orderByElem.getExpr())) continue;
                this.registerExprId(orderByElem.getExpr());
                exprMap.put(orderByElem.getExpr().getId().toString(), orderByElem.getExpr());
            }
        }
    }

    @Override
    public void putBackExprs(Map<String, Expr> rewrittenExprMap) {
        ArrayList subqueryExprs = Lists.newArrayList();
        for (SelectListItem item : this.selectList.getItems()) {
            if (item.isStar()) continue;
            item.setExpr(rewrittenExprMap.get(item.getExpr().getId().toString()));
            if (!item.getExpr().contains(Predicates.instanceOf(Subquery.class))) continue;
            item.getExpr().collect(Subquery.class, subqueryExprs);
        }
        for (TableRef ref : this.fromClause_) {
            if (ref.onClause != null) {
                ref.setOnClause(rewrittenExprMap.get(ref.onClause.getId().toString()));
            }
            if (!(ref instanceof InlineViewRef)) continue;
            ((InlineViewRef)ref).getViewStmt().putBackExprs(rewrittenExprMap);
        }
        if (this.whereClause != null) {
            this.setWhereClause(rewrittenExprMap.get(this.whereClause.getId().toString()));
            this.whereClause.collect(Subquery.class, subqueryExprs);
        }
        if (this.havingClause != null) {
            this.havingClause = rewrittenExprMap.get(this.havingClauseAfterAnaylzed.getId().toString());
            this.havingClauseAfterAnaylzed.collect(Subquery.class, subqueryExprs);
        }
        for (Subquery subquery : subqueryExprs) {
            subquery.getStatement().putBackExprs(rewrittenExprMap);
        }
        if (this.groupByClause != null) {
            List<Expr> oriGroupingExprs;
            ArrayList<Expr> groupingExprs = this.groupByClause.getGroupingExprs();
            if (groupingExprs != null) {
                ArrayList<Expr> newGroupingExpr = new ArrayList<Expr>();
                for (Expr expr : groupingExprs) {
                    if (expr.getId() == null) {
                        newGroupingExpr.add(expr);
                        continue;
                    }
                    newGroupingExpr.add(rewrittenExprMap.get(expr.getId().toString()));
                }
                this.groupByClause.setGroupingExpr(newGroupingExpr);
            }
            if ((oriGroupingExprs = this.groupByClause.getOriGroupingExprs()) != null) {
                ArrayList<Expr> newOriGroupingExprs = new ArrayList<Expr>();
                for (Expr expr : oriGroupingExprs) {
                    if (expr.getId() == null) {
                        newOriGroupingExprs.add(expr);
                        continue;
                    }
                    newOriGroupingExprs.add(rewrittenExprMap.get(expr.getId().toString()));
                }
                this.groupByClause.setOriGroupingExprs(newOriGroupingExprs);
            }
        }
        if (this.orderByElements != null) {
            for (OrderByElement orderByElem : this.orderByElements) {
                Expr expr = orderByElem.getExpr();
                if (expr.getId() == null) {
                    orderByElem.setExpr(expr);
                    continue;
                }
                orderByElem.setExpr(rewrittenExprMap.get(expr.getId().toString()));
            }
        }
    }

    private void rewriteSelectList(ExprRewriter rewriter) throws AnalysisException {
        for (SelectListItem item : this.selectList.getItems()) {
            if (!(item.getExpr() instanceof CaseExpr) || !item.getExpr().contains(Predicates.instanceOf(Subquery.class))) continue;
            this.rewriteSubquery(item.getExpr(), this.analyzer);
        }
        this.selectList.rewriteExprs(rewriter, this.analyzer);
    }

    private Expr rewriteSubquery(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (expr instanceof Subquery) {
            if (!(((Subquery)expr).getStatement() instanceof SelectStmt)) {
                throw new AnalysisException("Only support select subquery in case-when clause.");
            }
            if (expr.isCorrelatedPredicate(this.getTableRefIds())) {
                throw new AnalysisException("The correlated subquery in case-when clause is not supported");
            }
            SelectStmt subquery = (SelectStmt)((Subquery)expr).getStatement();
            if (subquery.resultExprs.size() != 1 || !subquery.returnsSingleRow()) {
                throw new AnalysisException("Subquery in case-when must return scala type");
            }
            subquery.reset();
            subquery.setAssertNumRowsElement(1, AssertNumRowsElement.Assertion.EQ);
            String alias = this.getTableAliasGenerator().getNextAlias();
            String colAlias = this.getColumnAliasGenerator().getNextAlias();
            InlineViewRef inlineViewRef = new InlineViewRef(alias, subquery, Arrays.asList(colAlias));
            try {
                inlineViewRef.analyze(analyzer);
            }
            catch (UserException e) {
                throw new AnalysisException(e.getMessage());
            }
            this.fromClause_.add(inlineViewRef);
            expr = new SlotRef(inlineViewRef.getAliasAsName(), colAlias);
        } else if (CollectionUtils.isNotEmpty(expr.getChildren())) {
            for (int i = 0; i < expr.getChildren().size(); ++i) {
                expr.setChild(i, this.rewriteSubquery((Expr)expr.getChild(i), analyzer));
            }
        }
        return expr;
    }

    @Override
    public String toSql() {
        int i;
        if (this.sqlString_ != null) {
            return this.sqlString_;
        }
        StringBuilder strBuilder = new StringBuilder();
        if (this.withClause_ != null) {
            strBuilder.append(this.withClause_.toSql());
            strBuilder.append(" ");
        }
        strBuilder.append("SELECT ");
        if (this.selectList.isDistinct()) {
            strBuilder.append("DISTINCT ");
        }
        for (i = 0; i < this.resultExprs.size(); ++i) {
            if (i != 0) {
                strBuilder.append(", ");
            }
            if (this.needToSql) {
                strBuilder.append(this.originalExpr.get(i).toSql());
            } else {
                strBuilder.append(((Expr)this.resultExprs.get(i)).toSql());
            }
            strBuilder.append(" AS ").append(SqlUtils.getIdentSql(this.colLabels.get(i)));
        }
        if (!this.fromClause_.isEmpty()) {
            strBuilder.append(this.fromClause_.toSql());
        }
        if (this.whereClause != null) {
            strBuilder.append(" WHERE ");
            strBuilder.append(this.whereClause.toSql());
        }
        if (this.groupByClause != null) {
            strBuilder.append(" GROUP BY ");
            strBuilder.append(this.groupByClause.toSql());
        }
        if (this.havingClause != null) {
            strBuilder.append(" HAVING ");
            strBuilder.append(this.havingClause.toSql());
        }
        if (this.orderByElements != null) {
            strBuilder.append(" ORDER BY ");
            for (i = 0; i < this.orderByElements.size(); ++i) {
                strBuilder.append(((OrderByElement)this.orderByElements.get(i)).getExpr().toSql());
                if (this.sortInfo != null) {
                    strBuilder.append(this.sortInfo.getIsAscOrder().get(i) != false ? " ASC" : " DESC");
                }
                strBuilder.append(i + 1 != this.orderByElements.size() ? ", " : "");
            }
        }
        if (this.hasLimitClause()) {
            strBuilder.append(this.limitElement.toSql());
        }
        if (this.hasOutFileClause()) {
            strBuilder.append(this.outFileClause.toSql());
        }
        return strBuilder.toString();
    }

    @Override
    public void getMaterializedTupleIds(ArrayList<TupleId> tupleIdList) {
        if (this.evaluateOrderBy) {
            tupleIdList.add(this.sortInfo.getSortTupleDescriptor().getId());
        } else if (this.aggInfo != null) {
            if (this.aggInfo.isDistinctAgg()) {
                tupleIdList.add(this.aggInfo.getSecondPhaseDistinctAggInfo().getOutputTupleId());
            } else {
                tupleIdList.add(this.aggInfo.getOutputTupleId());
            }
        } else {
            for (TableRef tblRef : this.fromClause_) {
                tupleIdList.addAll(tblRef.getMaterializedTupleIds());
            }
        }
        if (this.hasAnalyticInfo() && !this.isEvaluateOrderBy()) {
            tupleIdList.add(this.analyticInfo.getOutputTupleId());
        }
    }

    @Override
    public void substituteSelectList(Analyzer analyzer, List<String> newColLabels) throws AnalysisException, UserException {
        if (this.hasWithClause()) {
            this.withClause_.analyze(analyzer);
        }
        TableRef leftTblRef = null;
        for (int i = 0; i < this.fromClause_.size(); ++i) {
            TableRef tblRef = this.fromClause_.get(i);
            tblRef = analyzer.resolveTableRef(tblRef);
            Preconditions.checkNotNull((Object)tblRef);
            this.fromClause_.set(i, tblRef);
            tblRef.setLeftTblRef(leftTblRef);
            tblRef.analyze(analyzer);
            leftTblRef = tblRef;
        }
        for (SelectListItem item : this.selectList.getItems()) {
            if (item.isStar()) {
                TableName tblName = item.getTblName();
                if (tblName == null) {
                    this.expandStar(analyzer);
                    continue;
                }
                this.expandStar(analyzer, tblName);
                continue;
            }
            if (item.getExpr() instanceof AnalyticExpr) {
                item.getExpr().analyze(analyzer);
            }
            if (item.getAlias() != null) {
                SlotRef aliasRef = new SlotRef(null, item.getAlias());
                SlotRef newAliasRef = new SlotRef(null, newColLabels.get(this.resultExprs.size()));
                newAliasRef.analysisDone();
                this.aliasSMap.put(aliasRef, newAliasRef);
            }
            this.resultExprs.add(item.getExpr());
        }
        if (this.groupByClause != null) {
            this.substituteOrdinalsAliases(this.groupByClause.getGroupingExprs(), "GROUP BY", analyzer);
        }
        if (this.havingClause != null) {
            this.havingClause = this.havingClause.clone(this.aliasSMap);
        }
        if (this.orderByElements != null) {
            for (int i = 0; i < this.orderByElements.size(); ++i) {
                this.orderByElements = OrderByElement.substitute(this.orderByElements, this.aliasSMap, analyzer);
            }
        }
        this.colLabels.clear();
        this.colLabels.addAll(newColLabels);
    }

    public boolean hasWhereClause() {
        return this.whereClause != null;
    }

    public boolean hasAggInfo() {
        return this.aggInfo != null;
    }

    public boolean hasGroupByClause() {
        return this.groupByClause != null;
    }

    public boolean returnsSingleRow() {
        if (this.hasLimitClause() && this.getLimit() == 1L) {
            return true;
        }
        if (this.fromClause_.isEmpty()) {
            return true;
        }
        return this.hasAggInfo() && !this.hasGroupByClause() && !this.selectList.isDistinct();
    }

    @Override
    public void collectTableRefs(List<TableRef> tblRefs) {
        for (TableRef tblRef : this.fromClause_) {
            if (tblRef instanceof InlineViewRef) {
                InlineViewRef inlineViewRef = (InlineViewRef)tblRef;
                inlineViewRef.getViewStmt().collectTableRefs(tblRefs);
                continue;
            }
            tblRefs.add(tblRef);
        }
    }

    private boolean checkGroupingFn(Expr expr) {
        if (expr instanceof GroupingFunctionCallExpr) {
            return true;
        }
        if (expr.getChildren() != null && expr.getChildren().size() > 0) {
            for (Expr child : expr.getChildren()) {
                if (!this.checkGroupingFn(child)) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelectStmt)) {
            return false;
        }
        return this.id.equals(((SelectStmt)obj).id);
    }
}

