/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.AnalyticExpr;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.TableName;

public class SelectListItem {
    private Expr expr;
    private final TableName tblName;
    private final boolean isStar;
    private String alias;

    public SelectListItem(Expr expr, String alias) {
        Preconditions.checkNotNull((Object)expr);
        this.expr = expr;
        this.alias = alias;
        this.tblName = null;
        this.isStar = false;
    }

    private SelectListItem(TableName tblName) {
        this.expr = null;
        this.tblName = tblName;
        this.isStar = true;
    }

    protected SelectListItem(SelectListItem other) {
        this.expr = other.expr == null ? null : other.expr.clone().reset();
        this.tblName = other.tblName;
        this.isStar = other.isStar;
        this.alias = other.alias;
    }

    public SelectListItem clone() {
        return new SelectListItem(this);
    }

    public static SelectListItem createStarItem(TableName tblName) {
        return new SelectListItem(tblName);
    }

    public boolean isStar() {
        return this.isStar;
    }

    public TableName getTblName() {
        return this.tblName;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public void setExpr(Expr expr) {
        this.expr = expr;
    }

    public String getAlias() {
        return this.alias;
    }

    public String toSql() {
        if (!this.isStar) {
            Preconditions.checkNotNull((Object)this.expr);
            String aliasSql = null;
            if (this.alias != null) {
                aliasSql = "`" + this.alias + "`";
            }
            return this.expr.toSql() + (aliasSql == null ? "" : " " + aliasSql);
        }
        if (this.tblName != null) {
            return this.tblName.toString() + ".*";
        }
        return "*";
    }

    public String toColumnLabel() {
        Preconditions.checkState((!this.isStar() ? 1 : 0) != 0);
        if (this.alias != null) {
            return this.alias;
        }
        if (this.expr instanceof AnalyticExpr) {
            AnalyticExpr analyticExpr = (AnalyticExpr)this.expr;
            return analyticExpr.getFnCall().toSql() + " OVER(...)";
        }
        return this.expr.toColumnLabel();
    }
}

