/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.SelectListItem;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.rewrite.ExprRewriter;

public class SelectList {
    private static final String SET_VAR_KEY = "set_var";
    private boolean isDistinct;
    private Map<String, String> optHints;
    private final List<SelectListItem> items;

    public SelectList(SelectList other) {
        this.items = Lists.newArrayList();
        for (SelectListItem item : other.items) {
            this.items.add(item.clone());
        }
        this.isDistinct = other.isDistinct;
    }

    public SelectList() {
        this.items = Lists.newArrayList();
        this.isDistinct = false;
    }

    public SelectList(List<SelectListItem> items, boolean isDistinct) {
        this.isDistinct = isDistinct;
        this.items = items;
    }

    public List<SelectListItem> getItems() {
        return this.items;
    }

    public void addItem(SelectListItem item) {
        this.items.add(item);
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setIsDistinct(boolean value) {
        this.isDistinct = value;
    }

    public Map<String, String> getOptHints() {
        return this.optHints;
    }

    public void setOptHints(Map<String, Map<String, String>> optHints) {
        if (optHints != null) {
            this.optHints = optHints.get(SET_VAR_KEY);
        }
    }

    public void reset() {
        for (SelectListItem item : this.items) {
            if (item.isStar()) continue;
            item.getExpr().reset();
        }
    }

    public void rewriteExprs(ExprRewriter rewriter, Analyzer analyzer) throws AnalysisException {
        for (SelectListItem item : this.items) {
            if (item.isStar()) continue;
            if (item.getExpr().contains(Predicates.instanceOf(Subquery.class))) {
                ArrayList subqueryExprs = Lists.newArrayList();
                item.getExpr().collect(Subquery.class, subqueryExprs);
                for (Subquery s : subqueryExprs) {
                    s.getStatement().rewriteExprs(rewriter);
                }
            }
            item.setExpr(rewriter.rewrite(item.getExpr(), analyzer));
        }
    }

    public SelectList clone() {
        return new SelectList(this);
    }
}

