/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;

public class RollupRenameClause
extends AlterTableClause {
    private String rollupName;
    private String newRollupName;

    public RollupRenameClause(String rollupName, String newRollupName) {
        super(AlterOpType.RENAME);
        this.rollupName = rollupName;
        this.newRollupName = newRollupName;
        this.needTableStable = false;
    }

    public String getRollupName() {
        return this.rollupName;
    }

    public String getNewRollupName() {
        return this.newRollupName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.rollupName)) {
            throw new AnalysisException("Rollup name is not set");
        }
        if (Strings.isNullOrEmpty((String)this.newRollupName)) {
            throw new AnalysisException("New rollup name is not set");
        }
        FeNameFormat.checkTableName(this.newRollupName);
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public String toSql() {
        return "RENAME ROLLUP " + this.rollupName + " " + this.newRollupName;
    }

    public String toString() {
        return this.toSql();
    }
}

