/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.GrantStmt;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.AccessPrivilege;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;

public class RevokeStmt
extends DdlStmt {
    private UserIdentity userIdent;
    private String role;
    private TablePattern tblPattern;
    private ResourcePattern resourcePattern;
    private List<PaloPrivilege> privileges;

    public RevokeStmt(UserIdentity userIdent, String role, TablePattern tblPattern, List<AccessPrivilege> privileges) {
        this.userIdent = userIdent;
        this.role = role;
        this.tblPattern = tblPattern;
        this.resourcePattern = null;
        PrivBitSet privs = PrivBitSet.of(new PaloPrivilege[0]);
        for (AccessPrivilege accessPrivilege : privileges) {
            privs.or(accessPrivilege.toPaloPrivilege());
        }
        this.privileges = privs.toPrivilegeList();
    }

    public RevokeStmt(UserIdentity userIdent, String role, ResourcePattern resourcePattern, List<AccessPrivilege> privileges) {
        this.userIdent = userIdent;
        this.role = role;
        this.tblPattern = null;
        this.resourcePattern = resourcePattern;
        PrivBitSet privs = PrivBitSet.of(new PaloPrivilege[0]);
        for (AccessPrivilege accessPrivilege : privileges) {
            privs.or(accessPrivilege.toPaloPrivilege());
        }
        this.privileges = privs.toPrivilegeList();
    }

    public UserIdentity getUserIdent() {
        return this.userIdent;
    }

    public TablePattern getTblPattern() {
        return this.tblPattern;
    }

    public ResourcePattern getResourcePattern() {
        return this.resourcePattern;
    }

    public String getQualifiedRole() {
        return this.role;
    }

    public List<PaloPrivilege> getPrivileges() {
        return this.privileges;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.userIdent != null) {
            this.userIdent.analyze(analyzer.getClusterName());
        } else {
            FeNameFormat.checkRoleName(this.role, false, "Can not revoke from role");
            this.role = ClusterNamespace.getFullName(analyzer.getClusterName(), this.role);
        }
        if (this.tblPattern != null) {
            this.tblPattern.analyze(analyzer.getClusterName());
        } else {
            if (!Config.enable_spark_load) {
                throw new AnalysisException("REVOKE ON RESOURCE is comming soon");
            }
            this.resourcePattern.analyze();
        }
        if (this.privileges == null || this.privileges.isEmpty()) {
            throw new AnalysisException("No privileges in revoke statement.");
        }
        if (this.tblPattern != null) {
            GrantStmt.checkPrivileges(analyzer, this.privileges, this.role, this.tblPattern);
        } else {
            GrantStmt.checkPrivileges(analyzer, this.privileges, this.role, this.resourcePattern);
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("REVOKE ").append(Joiner.on((String)", ").join(this.privileges));
        if (this.tblPattern != null) {
            sb.append(" ON ").append(this.tblPattern).append(" FROM ");
        } else {
            sb.append(" ON RESOURCE '").append(this.resourcePattern).append("' FROM ");
        }
        if (!Strings.isNullOrEmpty((String)this.role)) {
            sb.append(" ROLE '").append(this.role).append("'");
        } else {
            sb.append(this.userIdent);
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

