/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.doris.analysis.AbstractBackupStmt;
import org.apache.doris.analysis.AbstractBackupTableRefClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.PropertyAnalyzer;

public class RestoreStmt
extends AbstractBackupStmt {
    private static final String PROP_ALLOW_LOAD = "allow_load";
    private static final String PROP_REPLICATION_NUM = "replication_num";
    private static final String PROP_BACKUP_TIMESTAMP = "backup_timestamp";
    private static final String PROP_META_VERSION = "meta_version";
    private boolean allowLoad = false;
    private ReplicaAllocation replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
    private String backupTimestamp = null;
    private int metaVersion = -1;

    public RestoreStmt(LabelName labelName, String repoName, AbstractBackupTableRefClause restoreTableRefClause, Map<String, String> properties) {
        super(labelName, repoName, restoreTableRefClause, properties);
    }

    public boolean allowLoad() {
        return this.allowLoad;
    }

    public ReplicaAllocation getReplicaAlloc() {
        return this.replicaAlloc;
    }

    public String getBackupTimestamp() {
        return this.backupTimestamp;
    }

    public int getMetaVersion() {
        return this.metaVersion;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
    }

    @Override
    protected void customAnalyzeTableRefClause() throws AnalysisException {
        HashSet aliasSet = Sets.newHashSet();
        for (TableRef tblRef : this.abstractBackupTableRefClause.getTableRefList()) {
            aliasSet.add(tblRef.getName().getTbl());
        }
        for (TableRef tblRef : this.abstractBackupTableRefClause.getTableRefList()) {
            if (!tblRef.hasExplicitAlias() || aliasSet.add(tblRef.getExplicitAlias())) continue;
            throw new AnalysisException("Duplicated alias name: " + tblRef.getExplicitAlias());
        }
    }

    @Override
    public void analyzeProperties() throws AnalysisException {
        super.analyzeProperties();
        HashMap copiedProperties = Maps.newHashMap((Map)this.properties);
        if (copiedProperties.containsKey(PROP_ALLOW_LOAD)) {
            if (((String)copiedProperties.get(PROP_ALLOW_LOAD)).equalsIgnoreCase("true")) {
                this.allowLoad = true;
            } else if (((String)copiedProperties.get(PROP_ALLOW_LOAD)).equalsIgnoreCase("false")) {
                this.allowLoad = false;
            } else {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Invalid allow load value: " + (String)copiedProperties.get(PROP_ALLOW_LOAD));
            }
            copiedProperties.remove(PROP_ALLOW_LOAD);
        }
        this.replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(copiedProperties, "");
        if (this.replicaAlloc.isNotSet()) {
            this.replicaAlloc = ReplicaAllocation.DEFAULT_ALLOCATION;
        }
        if (copiedProperties.containsKey(PROP_BACKUP_TIMESTAMP)) {
            this.backupTimestamp = (String)copiedProperties.get(PROP_BACKUP_TIMESTAMP);
            copiedProperties.remove(PROP_BACKUP_TIMESTAMP);
        } else {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Missing backup_timestamp property");
        }
        if (copiedProperties.containsKey(PROP_META_VERSION)) {
            try {
                this.metaVersion = Integer.valueOf((String)copiedProperties.get(PROP_META_VERSION));
            }
            catch (NumberFormatException e) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Invalid meta version format: " + (String)copiedProperties.get(PROP_META_VERSION));
            }
            copiedProperties.remove(PROP_META_VERSION);
        }
        if (!copiedProperties.isEmpty()) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_COMMON_ERROR, "Unknown restore job properties: " + copiedProperties.keySet());
        }
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("RESTORE SNAPSHOT ").append(this.labelName.toSql());
        sb.append("\n").append("FROM ").append(this.repoName).append("\n");
        if (this.abstractBackupTableRefClause != null) {
            sb.append(this.abstractBackupTableRefClause.toSql()).append("\n");
        }
        sb.append("PROPERTIES\n(");
        sb.append(new PrintableMap(this.properties, " = ", true, true));
        sb.append("\n)");
        return sb.toString();
    }
}

