/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PaloAuth;
import org.apache.doris.persist.gson.GsonUtils;

public class ResourcePattern
implements Writable {
    @SerializedName(value="resourceName")
    private String resourceName;
    public static ResourcePattern ALL = new ResourcePattern("*");

    private ResourcePattern() {
    }

    public ResourcePattern(String resourceName) {
        this.resourceName = Strings.isNullOrEmpty((String)resourceName) ? "*" : resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public PaloAuth.PrivLevel getPrivLevel() {
        if (this.resourceName.equals("*")) {
            return PaloAuth.PrivLevel.GLOBAL;
        }
        return PaloAuth.PrivLevel.RESOURCE;
    }

    public void analyze() throws AnalysisException {
        if (!this.resourceName.equals("*")) {
            FeNameFormat.checkResourceName(this.resourceName);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourcePattern)) {
            return false;
        }
        ResourcePattern other = (ResourcePattern)obj;
        return this.resourceName.equals(other.getResourceName());
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.resourceName.hashCode();
        return result;
    }

    public String toString() {
        return this.resourceName;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static ResourcePattern read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (ResourcePattern)GsonUtils.GSON.fromJson(json, ResourcePattern.class);
    }

    static {
        try {
            ALL.analyze();
        }
        catch (AnalysisException analysisException) {
            // empty catch block
        }
    }
}

