/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Resource;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.load.EtlJobType;

public class ResourceDesc {
    protected String name;
    protected Map<String, String> properties;
    protected EtlJobType etlJobType;

    private ResourceDesc() {
    }

    public ResourceDesc(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
        if (this.properties == null) {
            this.properties = Maps.newHashMap();
        }
        this.etlJobType = EtlJobType.UNKNOWN;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public EtlJobType getEtlJobType() {
        return this.etlJobType;
    }

    public void analyze() throws AnalysisException {
        Resource resource = Catalog.getCurrentCatalog().getResourceMgr().getResource(this.getName());
        if (resource == null) {
            throw new AnalysisException("Resource does not exist. name: " + this.getName());
        }
        if (resource.getType() == Resource.ResourceType.SPARK) {
            this.etlJobType = EtlJobType.SPARK;
        }
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("WITH RESOURCE '").append(this.name).append("'");
        if (this.properties != null && !this.properties.isEmpty()) {
            PrintableMap<String, String> printableMap = new PrintableMap<String, String>(this.properties, " = ", true, false, true);
            sb.append(" (").append(printableMap.toString()).append(")");
        }
        return sb.toString();
    }
}

