/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.parquet.Strings;

public class ReplaceTableClause
extends AlterTableClause {
    private String tblName;
    private Map<String, String> properties;
    private boolean swapTable;

    public ReplaceTableClause(String tblName, Map<String, String> properties) {
        super(AlterOpType.REPLACE_TABLE);
        this.tblName = tblName;
        this.properties = properties;
    }

    public String getTblName() {
        return this.tblName;
    }

    public boolean isSwapTable() {
        return this.swapTable;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.tblName)) {
            throw new AnalysisException("No table specified");
        }
        this.swapTable = PropertyAnalyzer.analyzeBooleanProp(this.properties, "swap", true);
        if (this.properties != null && !this.properties.isEmpty()) {
            throw new AnalysisException("Unknown properties: " + this.properties.keySet());
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("REPLACE WITH TABLE ").append(this.tblName);
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

