/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.PartitionNames;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PropertyAnalyzer;

public class ReplacePartitionClause
extends AlterTableClause {
    private PartitionNames partitionNames;
    private PartitionNames tempPartitionNames;
    private Map<String, String> properties = Maps.newHashMap();
    private boolean isStrictRange;
    private boolean useTempPartitionName;

    public ReplacePartitionClause(PartitionNames partitionNames, PartitionNames tempPartitionNames, Map<String, String> properties) {
        super(AlterOpType.REPLACE_PARTITION);
        this.partitionNames = partitionNames;
        this.tempPartitionNames = tempPartitionNames;
        this.needTableStable = false;
        this.properties = properties;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames.getPartitionNames();
    }

    public List<String> getTempPartitionNames() {
        return this.tempPartitionNames.getPartitionNames();
    }

    public boolean isStrictRange() {
        return this.isStrictRange;
    }

    public boolean useTempPartitionName() {
        return this.useTempPartitionName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.partitionNames == null || this.tempPartitionNames == null) {
            throw new AnalysisException("No partition specified");
        }
        this.partitionNames.analyze(analyzer);
        this.tempPartitionNames.analyze(analyzer);
        if (this.partitionNames.isTemp() || !this.tempPartitionNames.isTemp()) {
            throw new AnalysisException("Only support replace partitions with temp partitions");
        }
        this.isStrictRange = PropertyAnalyzer.analyzeBooleanProp(this.properties, "strict_range", true);
        this.useTempPartitionName = PropertyAnalyzer.analyzeBooleanProp(this.properties, "use_temp_partition_name", false);
        if (this.properties != null && !this.properties.isEmpty()) {
            throw new AnalysisException("Unknown properties: " + this.properties.keySet());
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("REPLACE PARTITION(");
        sb.append(Joiner.on((String)", ").join(this.partitionNames.getPartitionNames())).append(")");
        sb.append(" WITH TEMPORARY PARTITION(");
        sb.append(Joiner.on((String)", ").join(this.tempPartitionNames.getPartitionNames())).append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

