/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;

public class ReorderColumnsClause
extends AlterTableClause {
    private List<String> columnsByPos;
    private String rollupName;
    private Map<String, String> properties;

    public List<String> getColumnsByPos() {
        return this.columnsByPos;
    }

    public String getRollupName() {
        return this.rollupName;
    }

    public ReorderColumnsClause(List<String> cols, String rollup, Map<String, String> properties) {
        super(AlterOpType.SCHEMA_CHANGE);
        this.columnsByPos = cols;
        this.rollupName = rollup;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.columnsByPos == null || this.columnsByPos.isEmpty()) {
            throw new AnalysisException("No column in reorder columns clause.");
        }
        for (String col : this.columnsByPos) {
            if (!Strings.isNullOrEmpty((String)col)) continue;
            throw new AnalysisException("Empty column in reorder columns.");
        }
        if (Strings.isNullOrEmpty((String)this.rollupName)) {
            this.rollupName = null;
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("ORDER BY ");
        int idx = 0;
        for (String col : this.columnsByPos) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append("`").append(col).append('`');
            ++idx;
        }
        if (this.rollupName != null) {
            sb.append(" IN `").append(this.rollupName).append("`");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

