/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.TableName;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PaloPrivilege;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

public class RecoverTableStmt
extends DdlStmt {
    private TableName dbTblName;

    public RecoverTableStmt(TableName dbTblName) {
        this.dbTblName = dbTblName;
    }

    public String getDbName() {
        return this.dbTblName.getDb();
    }

    public String getTableName() {
        return this.dbTblName.getTbl();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        this.dbTblName.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), this.dbTblName.getDb(), this.dbTblName.getTbl(), PrivPredicate.of(PrivBitSet.of(PaloPrivilege.ALTER_PRIV, PaloPrivilege.CREATE_PRIV, PaloPrivilege.ADMIN_PRIV), CompoundPredicate.Operator.OR))) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "RECOVERY", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), this.dbTblName.getDb() + ": " + this.dbTblName.getTbl());
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("RECOVER TABLE ");
        if (!Strings.isNullOrEmpty((String)this.getDbName())) {
            sb.append(this.getDbName()).append(".");
        }
        sb.append(this.getTableName());
        return sb.toString();
    }
}

