/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.PartitionDesc;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.RangePartitionInfo;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;

public class RangePartitionDesc
extends PartitionDesc {
    public RangePartitionDesc(List<String> partitionColNames, List<SinglePartitionDesc> singlePartitionDescs) {
        super(partitionColNames, singlePartitionDescs);
        this.type = PartitionType.RANGE;
    }

    @Override
    public void checkPartitionKeyValueType(PartitionKeyDesc partitionKeyDesc) throws AnalysisException {
        if (partitionKeyDesc.getPartitionType() != PartitionKeyDesc.PartitionKeyValueType.FIXED && partitionKeyDesc.getPartitionType() != PartitionKeyDesc.PartitionKeyValueType.LESS_THAN) {
            throw new AnalysisException("You can only use fixed or less than values to create range partitions");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("PARTITION BY RANGE(");
        int idx = 0;
        for (String column : this.partitionColNames) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append("`").append(column).append("`");
            ++idx;
        }
        sb.append(")\n(\n");
        for (int i = 0; i < this.singlePartitionDescs.size(); ++i) {
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append(((SinglePartitionDesc)this.singlePartitionDescs.get(i)).toSql());
        }
        sb.append("\n)");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public PartitionInfo toPartitionInfo(List<Column> schema, Map<String, Long> partitionNameToId, boolean isTemp) throws DdlException {
        ArrayList<Column> partitionColumns = new ArrayList<Column>();
        for (String colName : this.partitionColNames) {
            boolean find = false;
            for (Column column : schema) {
                if (column.getName().equalsIgnoreCase(colName)) {
                    try {
                        RangePartitionInfo.checkPartitionColumn(column);
                    }
                    catch (AnalysisException e) {
                        throw new DdlException(e.getMessage());
                    }
                    partitionColumns.add(column);
                    find = true;
                    break;
                }
                if (!column.getType().isComplexType()) continue;
                throw new DdlException("Complex type column can't be partition column: " + column.getType().toString());
            }
            if (find) continue;
            throw new DdlException("Partition column[" + colName + "] does not found");
        }
        RangePartitionInfo rangePartitionInfo = new RangePartitionInfo(partitionColumns);
        for (SinglePartitionDesc desc : this.singlePartitionDescs) {
            long partitionId = partitionNameToId.get(desc.getPartitionName());
            rangePartitionInfo.handleNewSinglePartitionDesc(desc, partitionId, isTemp);
        }
        return rangePartitionInfo;
    }
}

