/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.DistributionDesc;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.RandomDistributionInfo;
import org.apache.doris.common.AnalysisException;

public class RandomDistributionDesc
extends DistributionDesc {
    int numBucket;

    public RandomDistributionDesc() {
        this.type = DistributionInfo.DistributionInfoType.RANDOM;
    }

    public RandomDistributionDesc(int numBucket) {
        this.type = DistributionInfo.DistributionInfoType.RANDOM;
        this.numBucket = numBucket;
    }

    @Override
    public void analyze(Set<String> colSet, List<ColumnDef> columnDefs) throws AnalysisException {
        if (this.numBucket <= 0) {
            throw new AnalysisException("Number of random distribution should be larger than zero.");
        }
    }

    @Override
    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DISTRIBUTED BY RANDOM\n").append("BUCKETS ").append(this.numBucket);
        return stringBuilder.toString();
    }

    @Override
    public DistributionInfo toDistributionInfo(List<Column> columns) {
        RandomDistributionInfo randomDistributionInfo = new RandomDistributionInfo(this.numBucket);
        return randomDistributionInfo;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.numBucket);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        this.numBucket = in.readInt();
    }
}

