/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.AssertNumRowsElement;
import org.apache.doris.analysis.ExplainOptions;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LimitElement;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.OutFileClause;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SortInfo;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.WithClause;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.rewrite.ExprRewriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class QueryStmt
extends StatementBase {
    private static final Logger LOG = LogManager.getLogger(QueryStmt.class);
    protected WithClause withClause_;
    protected ArrayList<OrderByElement> orderByElements;
    protected LimitElement limitElement;
    protected AssertNumRowsElement assertNumRowsElement;
    protected ArrayList<Expr> resultExprs = Lists.newArrayList();
    protected ArrayList<Expr> baseTblResultExprs = Lists.newArrayList();
    protected final ExprSubstitutionMap aliasSMap;
    protected final ArrayList<Expr> ambiguousAliasList;
    protected SortInfo sortInfo;
    protected boolean evaluateOrderBy;
    protected boolean needToSql = false;
    protected boolean fromInsert = false;
    protected List<OrderByElement> orderByElementsAfterAnalyzed;
    protected OutFileClause outFileClause;
    private boolean forbiddenMVRewrite = false;
    private Set<TupleId> disableTuplesMVRewriter = Sets.newHashSet();

    QueryStmt(ArrayList<OrderByElement> orderByElements, LimitElement limitElement) {
        this.orderByElements = orderByElements;
        this.limitElement = limitElement;
        this.aliasSMap = new ExprSubstitutionMap();
        this.ambiguousAliasList = Lists.newArrayList();
        this.sortInfo = null;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (this.isAnalyzed()) {
            return;
        }
        super.analyze(analyzer);
        this.analyzeLimit(analyzer);
        if (this.hasWithClause()) {
            this.withClause_.analyze(analyzer);
        }
    }

    private void analyzeLimit(Analyzer analyzer) throws AnalysisException {
        if (this.limitElement.getOffset() > 0L && !this.hasOrderByClause()) {
            throw new AnalysisException("OFFSET requires an ORDER BY clause: " + this.limitElement.toSql().trim());
        }
        this.limitElement.analyze(analyzer);
    }

    public List<TupleId> getCorrelatedTupleIds(Analyzer analyzer) throws AnalysisException {
        ArrayList correlatedTupleIds = Lists.newArrayList();
        TableRef correlatedRef = null;
        TableRef absoluteRef = null;
        HashSet tblRefIds = Sets.newHashSet();
        ArrayList tblRefs = Lists.newArrayList();
        this.collectTableRefs(tblRefs);
        for (TableRef tblRef : tblRefs) {
            if (absoluteRef == null && !tblRef.isRelative()) {
                absoluteRef = tblRef;
            }
            if (correlatedRef != null && absoluteRef != null) {
                throw new AnalysisException(String.format("Nested query is illegal because it contains a table reference '%s' correlated with an outer block as well as an uncorrelated one '%s':\n%s", correlatedRef.tableRefToSql(), absoluteRef.tableRefToSql(), this.toSql()));
            }
            tblRefIds.add(tblRef.getId());
        }
        return correlatedTupleIds;
    }

    public boolean isEvaluateOrderBy() {
        return this.evaluateOrderBy;
    }

    public ArrayList<Expr> getBaseTblResultExprs() {
        return this.baseTblResultExprs;
    }

    public void setNeedToSql(boolean needToSql) {
        this.needToSql = needToSql;
    }

    protected Expr rewriteQueryExprByMvColumnExpr(Expr expr, Analyzer analyzer) throws AnalysisException {
        if (this.forbiddenMVRewrite) {
            return expr;
        }
        if (expr.isBoundByTupleIds(this.disableTuplesMVRewriter.stream().collect(Collectors.toList()))) {
            return expr;
        }
        ExprRewriter rewriter = analyzer.getMVExprRewriter();
        rewriter.reset();
        return rewriter.rewrite(expr, analyzer);
    }

    protected void createSortInfo(Analyzer analyzer) throws AnalysisException {
        if (this.orderByElements == null) {
            this.evaluateOrderBy = false;
            return;
        }
        ArrayList orderingExprs = Lists.newArrayList();
        ArrayList isAscOrder = Lists.newArrayList();
        ArrayList nullsFirstParams = Lists.newArrayList();
        for (OrderByElement orderByElement : this.orderByElements) {
            orderingExprs.add(orderByElement.getExpr().clone());
            isAscOrder.add(orderByElement.getIsAsc());
            nullsFirstParams.add(orderByElement.getNullsFirstParam());
        }
        this.substituteOrdinalsAliases(orderingExprs, "ORDER BY", analyzer);
        this.orderByElementsAfterAnalyzed = Lists.newArrayList();
        for (int i = 0; i < this.orderByElements.size(); ++i) {
            OrderByElement orderByElement;
            orderingExprs.set(i, this.rewriteQueryExprByMvColumnExpr((Expr)orderingExprs.get(i), analyzer));
            orderByElement = new OrderByElement((Expr)orderingExprs.get(i), (Boolean)isAscOrder.get(i), (Boolean)nullsFirstParams.get(i));
            this.orderByElementsAfterAnalyzed.add(orderByElement);
        }
        if (!analyzer.isRootAnalyzer() && this.hasOffset() && !this.hasLimit()) {
            throw new AnalysisException("Order-by with offset without limit not supported in nested queries.");
        }
        this.sortInfo = new SortInfo(orderingExprs, isAscOrder, nullsFirstParams);
        if (!(this.hasLimit() || this.hasOffset() || analyzer.isRootAnalyzer() && !this.fromInsert)) {
            this.evaluateOrderBy = false;
            if (LOG.isDebugEnabled()) {
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append("Ignoring ORDER BY clause without LIMIT or OFFSET: ");
                strBuilder.append("ORDER BY ");
                strBuilder.append(this.orderByElements.get(0).toSql());
                for (int i = 1; i < this.orderByElements.size(); ++i) {
                    strBuilder.append(", ").append(this.orderByElements.get(i).toSql());
                }
                strBuilder.append(".\nAn ORDER BY appearing in a view, subquery, union operand, ");
                strBuilder.append("or an insert/ctas statement has no effect on the query result ");
                strBuilder.append("unless a LIMIT and/or OFFSET is used in conjunction ");
                strBuilder.append("with the ORDER BY.");
                LOG.debug(strBuilder.toString());
            }
        } else {
            this.evaluateOrderBy = true;
        }
    }

    protected void createSortTupleInfo(Analyzer analyzer) throws AnalysisException {
        Preconditions.checkState((boolean)this.evaluateOrderBy);
        for (Expr orderingExpr : this.sortInfo.getOrderingExprs()) {
            if (!orderingExpr.getType().isComplexType()) continue;
            throw new AnalysisException(String.format("ORDER BY expression '%s' with complex type '%s' is not supported.", orderingExpr.toSql(), orderingExpr.getType().toSql()));
        }
        ExprSubstitutionMap smap = this.sortInfo.createSortTupleInfo(this.resultExprs, analyzer);
        for (int i = 0; i < smap.size(); ++i) {
            if (smap.getLhs().get(i) instanceof SlotRef && smap.getRhs().get(i) instanceof SlotRef) continue;
        }
        this.substituteResultExprs(smap, analyzer);
    }

    protected Expr getFirstAmbiguousAlias(List<Expr> exprs) {
        for (Expr exp : exprs) {
            if (!this.ambiguousAliasList.contains(exp)) continue;
            return exp;
        }
        return null;
    }

    protected Expr getFirstAmbiguousAlias(Expr expr) {
        return expr.findEqual(this.ambiguousAliasList);
    }

    protected void substituteOrdinalsAliases(List<Expr> exprs, String errorPrefix, Analyzer analyzer) throws AnalysisException {
        Expr ambiguousAlias = this.getFirstAmbiguousAlias(exprs);
        if (ambiguousAlias != null) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_NON_UNIQ_ERROR, ambiguousAlias.toColumnLabel());
        }
        ListIterator<Expr> i = exprs.listIterator();
        while (i.hasNext()) {
            Expr expr = i.next();
            Expr substituteExpr = this.trySubstituteOrdinal(expr, errorPrefix, analyzer);
            if (substituteExpr == null) {
                substituteExpr = expr.trySubstitute(this.aliasSMap, analyzer, false);
            }
            i.set(substituteExpr);
        }
    }

    private Expr trySubstituteOrdinal(Expr expr, String errorPrefix, Analyzer analyzer) throws AnalysisException {
        if (!(expr instanceof IntLiteral)) {
            return null;
        }
        expr.analyze(analyzer);
        if (!expr.getType().isIntegerType()) {
            return null;
        }
        long pos = ((IntLiteral)expr).getLongValue();
        if (pos < 1L) {
            throw new AnalysisException(errorPrefix + ": ordinal must be >= 1: " + expr.toSql());
        }
        if (pos > (long)this.resultExprs.size()) {
            throw new AnalysisException(errorPrefix + ": ordinal exceeds number of items in select list: " + expr.toSql());
        }
        return this.resultExprs.get((int)pos - 1).clone();
    }

    public void getWithClauseTables(Analyzer analyzer, Map<Long, Table> tableMap, Set<String> parentViewNameSet) throws AnalysisException {
        if (this.withClause_ != null) {
            this.withClause_.getTables(analyzer, tableMap, parentViewNameSet);
        }
    }

    public void getWithClauseTableRefs(Analyzer analyzer, List<TableRef> tblRefs, Set<String> parentViewNameSet) {
        if (this.withClause_ != null) {
            this.withClause_.getTableRefs(analyzer, tblRefs, parentViewNameSet);
        }
    }

    public void collectExprs(Map<String, Expr> exprMap) {
    }

    public void putBackExprs(Map<String, Expr> rewrittenExprMap) {
    }

    @Override
    public void foldConstant(ExprRewriter rewriter) throws AnalysisException {
        Preconditions.checkState((boolean)this.isAnalyzed());
        HashMap<String, Expr> exprMap = new HashMap<String, Expr>();
        this.collectExprs(exprMap);
        rewriter.rewriteConstant(exprMap, this.analyzer);
        if (rewriter.changed()) {
            this.putBackExprs(exprMap);
        }
    }

    public void registerExprId(Expr expr) {
        if (expr.getId() == null) {
            this.analyzer.registerExprId(expr);
        }
        for (Expr child : expr.getChildren()) {
            this.registerExprId(child);
        }
    }

    public boolean containAlias(Expr expr) {
        for (Expr child : expr.getChildren()) {
            if (!this.containAlias(child)) continue;
            return true;
        }
        return null != this.aliasSMap.get(expr);
    }

    public abstract void getTables(Analyzer var1, Map<Long, Table> var2, Set<String> var3) throws AnalysisException;

    public abstract void getTableRefs(Analyzer var1, List<TableRef> var2, Set<String> var3);

    public abstract ArrayList<String> getColLabels();

    public abstract void getMaterializedTupleIds(ArrayList<TupleId> var1);

    public abstract void collectTableRefs(List<TableRef> var1);

    abstract List<TupleId> collectTupleIds();

    public ArrayList<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public List<OrderByElement> getOrderByElementsAfterAnalyzed() {
        return this.orderByElementsAfterAnalyzed;
    }

    public void removeOrderByElements() {
        this.orderByElements = null;
    }

    public void setWithClause(WithClause withClause) {
        this.withClause_ = withClause;
    }

    public boolean hasWithClause() {
        return this.withClause_ != null;
    }

    public WithClause getWithClause() {
        return this.withClause_;
    }

    public boolean hasOrderByClause() {
        return this.orderByElements != null;
    }

    public boolean hasLimit() {
        return this.limitElement != null && this.limitElement.hasLimit();
    }

    public boolean hasOffset() {
        return this.limitElement != null && this.limitElement.hasOffset();
    }

    public long getLimit() {
        return this.limitElement.getLimit();
    }

    public void setLimit(long limit) throws AnalysisException {
        Preconditions.checkState((limit >= 0L ? 1 : 0) != 0);
        long newLimit = this.hasLimitClause() ? Math.min(limit, this.getLimit()) : limit;
        this.limitElement = new LimitElement(newLimit);
    }

    public void removeLimitElement() {
        this.limitElement = LimitElement.NO_LIMIT;
    }

    public long getOffset() {
        return this.limitElement.getOffset();
    }

    public void setAssertNumRowsElement(int desiredNumOfRows, AssertNumRowsElement.Assertion assertion) {
        this.assertNumRowsElement = new AssertNumRowsElement(desiredNumOfRows, this.toSql(), assertion);
    }

    public AssertNumRowsElement getAssertNumRowsElement() {
        return this.assertNumRowsElement;
    }

    @Override
    public void setIsExplain(ExplainOptions options) {
        this.explainOptions = options;
    }

    @Override
    public boolean isExplain() {
        return this.explainOptions != null;
    }

    public boolean hasLimitClause() {
        return this.limitElement.hasLimit();
    }

    public SortInfo getSortInfo() {
        return this.sortInfo;
    }

    public boolean evaluateOrderBy() {
        return this.evaluateOrderBy;
    }

    public ArrayList<Expr> getResultExprs() {
        return this.resultExprs;
    }

    public void substituteResultExprs(ExprSubstitutionMap smap, Analyzer analyzer) {
        this.resultExprs = Expr.substituteList(this.resultExprs, smap, analyzer, true);
    }

    public boolean isForbiddenMVRewrite() {
        return this.forbiddenMVRewrite;
    }

    public void forbiddenMVRewrite() {
        this.forbiddenMVRewrite = true;
    }

    public void updateDisableTuplesMVRewriter(TupleId tupleId) {
        this.disableTuplesMVRewriter.add(tupleId);
    }

    public void updateDisableTuplesMVRewriter(Set<TupleId> tupleIds) {
        this.disableTuplesMVRewriter.addAll(tupleIds);
    }

    public Set<TupleId> getDisableTuplesMVRewriter() {
        return this.disableTuplesMVRewriter;
    }

    public abstract void materializeRequiredSlots(Analyzer var1) throws AnalysisException;

    protected void materializeSlots(Analyzer analyzer, List<Expr> exprs) {
        ArrayList slotIds = Lists.newArrayList();
        for (Expr e : exprs) {
            e.getIds(null, slotIds);
        }
        analyzer.getDescTbl().markSlotsMaterialized(slotIds);
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.NO_FORWARD;
    }

    public ArrayList<OrderByElement> cloneOrderByElements() {
        if (this.orderByElements == null) {
            return null;
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)this.orderByElements.size());
        for (OrderByElement o : this.orderByElements) {
            result.add(o.clone());
        }
        return result;
    }

    public WithClause cloneWithClause() {
        return this.withClause_ != null ? this.withClause_.clone() : null;
    }

    public OutFileClause cloneOutfileCluse() {
        return this.outFileClause != null ? this.outFileClause.clone() : null;
    }

    protected QueryStmt(QueryStmt other) {
        super(other);
        this.withClause_ = other.cloneWithClause();
        this.outFileClause = other.cloneOutfileCluse();
        this.orderByElements = other.cloneOrderByElements();
        this.limitElement = other.limitElement.clone();
        this.resultExprs = Expr.cloneList(other.resultExprs);
        this.baseTblResultExprs = Expr.cloneList(other.baseTblResultExprs);
        this.aliasSMap = other.aliasSMap.clone();
        this.ambiguousAliasList = Expr.cloneList(other.ambiguousAliasList);
        this.sortInfo = other.sortInfo != null ? other.sortInfo.clone() : null;
        this.analyzer = other.analyzer;
        this.evaluateOrderBy = other.evaluateOrderBy;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.orderByElements != null) {
            for (OrderByElement o : this.orderByElements) {
                o.getExpr().reset();
            }
        }
        this.limitElement.reset();
        this.resultExprs.clear();
        this.baseTblResultExprs.clear();
        this.aliasSMap.clear();
        this.ambiguousAliasList.clear();
        this.orderByElementsAfterAnalyzed = null;
        this.sortInfo = null;
        this.evaluateOrderBy = false;
        this.fromInsert = false;
    }

    public abstract void resetSelectList();

    public void setFromInsert(boolean value) {
        this.fromInsert = value;
    }

    public abstract QueryStmt clone();

    public abstract void substituteSelectList(Analyzer var1, List<String> var2) throws AnalysisException, UserException;

    public void setOutFileClause(OutFileClause outFileClause) {
        this.outFileClause = outFileClause;
    }

    public OutFileClause getOutFileClause() {
        return this.outFileClause;
    }

    public boolean hasOutFileClause() {
        return this.outFileClause != null;
    }
}

