/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InPredicate;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.Reference;

public abstract class Predicate
extends Expr {
    protected boolean isEqJoinConjunct;

    public Predicate() {
        this.isEqJoinConjunct = false;
    }

    protected Predicate(Predicate other) {
        super(other);
        this.isEqJoinConjunct = other.isEqJoinConjunct;
    }

    public boolean isEqJoinConjunct() {
        return this.isEqJoinConjunct;
    }

    public void setIsEqJoinConjunct(boolean v) {
        this.isEqJoinConjunct = v;
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        this.type = Type.BOOLEAN;
        this.numDistinctValues = 3L;
    }

    public boolean isSingleColumnPredicate(Reference<SlotRef> slotRefRef, Reference<Integer> idxRef) {
        int i;
        SlotRef slotRef = null;
        for (i = 0; i < this.children.size() && (slotRef = ((Expr)this.getChild(i)).unwrapSlotRef()) == null; ++i) {
        }
        if (slotRef == null) {
            return false;
        }
        for (int j = 0; j < this.children.size(); ++j) {
            if (i == j || ((Expr)this.getChild(j)).isConstant()) continue;
            return false;
        }
        if (slotRefRef != null) {
            slotRefRef.setRef(slotRef);
        }
        if (idxRef != null) {
            idxRef.setRef(i);
        }
        return true;
    }

    public static boolean isEquivalencePredicate(Expr expr) {
        return expr instanceof BinaryPredicate && ((BinaryPredicate)expr).getOp().isEquivalence();
    }

    public static boolean isUnNullSafeEquivalencePredicate(Expr expr) {
        return expr instanceof BinaryPredicate && ((BinaryPredicate)expr).getOp().isUnNullSafeEquivalence();
    }

    public static boolean canPushDownPredicate(Expr expr) {
        if (!(expr instanceof Predicate)) {
            return false;
        }
        if (((Predicate)expr).isSingleColumnPredicate(null, null)) {
            if (expr instanceof BinaryPredicate) {
                BinaryPredicate binPredicate = (BinaryPredicate)expr;
                Expr right = (Expr)binPredicate.getChild(1);
                Preconditions.checkState((right != null ? 1 : 0) != 0);
                if (!right.isConstant()) {
                    return false;
                }
                return right instanceof LiteralExpr;
            }
            if (expr instanceof InPredicate) {
                InPredicate inPredicate = (InPredicate)expr;
                return inPredicate.isLiteralChildren();
            }
        }
        return false;
    }

    public Pair<SlotId, SlotId> getEqSlots() {
        return null;
    }
}

