/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;

public class PauseRoutineLoadStmt
extends DdlStmt {
    private final LabelName labelName;
    private String db;

    public PauseRoutineLoadStmt(LabelName labelName) {
        this.labelName = labelName;
    }

    public boolean isAll() {
        return this.labelName == null;
    }

    public String getName() {
        return this.labelName.getLabelName();
    }

    public String getDbFullName() {
        return this.db;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        if (this.labelName != null) {
            this.labelName.analyze(analyzer);
            this.db = this.labelName.getDbName();
        } else {
            if (Strings.isNullOrEmpty((String)analyzer.getDefaultDb())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            this.db = ClusterNamespace.getFullName(analyzer.getClusterName(), analyzer.getDefaultDb());
        }
    }
}

