/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;

public class PartitionValue {
    public static final PartitionValue MAX_VALUE = new PartitionValue();
    private String value;

    private PartitionValue() {
    }

    public PartitionValue(String value) {
        this.value = value;
    }

    public LiteralExpr getValue(Type type) throws AnalysisException {
        if (this.isMax()) {
            return LiteralExpr.createInfinity(type, true);
        }
        return LiteralExpr.create(this.value, type);
    }

    public boolean isMax() {
        return this == MAX_VALUE;
    }

    public String getStringValue() {
        if (this.isMax()) {
            return "MAXVALUE";
        }
        return this.value;
    }
}

