/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.FeNameFormat;

public class PartitionRenameClause
extends AlterTableClause {
    private String partitionName;
    private String newPartitionName;

    public PartitionRenameClause(String partitionName, String newPartitionName) {
        super(AlterOpType.RENAME);
        this.partitionName = partitionName;
        this.newPartitionName = newPartitionName;
        this.needTableStable = false;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getNewPartitionName() {
        return this.newPartitionName;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.partitionName)) {
            throw new AnalysisException("Partition name is not set");
        }
        if (Strings.isNullOrEmpty((String)this.newPartitionName)) {
            throw new AnalysisException("New partition name is not set");
        }
        FeNameFormat.checkPartitionName(this.newPartitionName);
    }

    @Override
    public Map<String, String> getProperties() {
        return null;
    }

    @Override
    public String toSql() {
        return "RENAME PARTITION " + this.partitionName + " " + this.newPartitionName;
    }

    public String toString() {
        return this.toSql();
    }
}

