/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class PartitionNames
implements ParseNode,
Writable {
    @SerializedName(value="partitionNames")
    private final List<String> partitionNames;
    @SerializedName(value="isTemp")
    private final boolean isTemp;

    public PartitionNames(boolean isTemp, List<String> partitionNames) {
        this.partitionNames = partitionNames;
        this.isTemp = isTemp;
    }

    public PartitionNames(PartitionNames other) {
        this.partitionNames = Lists.newArrayList(other.partitionNames);
        this.isTemp = other.isTemp;
    }

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public boolean isTemp() {
        return this.isTemp;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.partitionNames.isEmpty()) {
            throw new AnalysisException("No partition specified in partition lists");
        }
        if (this.partitionNames.stream().anyMatch(entity -> Strings.isNullOrEmpty((String)entity))) {
            throw new AnalysisException("there are empty partition name");
        }
    }

    @Override
    public String toSql() {
        if (this.partitionNames == null || this.partitionNames.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isTemp) {
            sb.append("TEMPORARY ");
        }
        sb.append("PARTITIONS (");
        sb.append(Joiner.on((String)", ").join(this.partitionNames));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static PartitionNames read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (PartitionNames)GsonUtils.GSON.fromJson(json, PartitionNames.class);
    }
}

