/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TableName;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;

public class PartitionName {
    private final String tableName;
    private String newTableName;
    private String partitionName;
    private String newPartitionName;

    public PartitionName(String tableName, String newTableName, String partitionName, String newPartitionName) {
        this.tableName = Strings.nullToEmpty((String)tableName);
        this.newTableName = Strings.nullToEmpty((String)newTableName);
        this.partitionName = Strings.nullToEmpty((String)partitionName);
        this.newPartitionName = Strings.nullToEmpty((String)newPartitionName);
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.tableName)) {
            throw new AnalysisException("Table name is null");
        }
        if (!this.newTableName.isEmpty()) {
            if (this.partitionName.isEmpty() && !this.newPartitionName.isEmpty() || this.newPartitionName.isEmpty() && !this.partitionName.isEmpty()) {
                throw new AnalysisException("Partition name is missing");
            }
            if (!this.partitionName.equalsIgnoreCase(this.newPartitionName)) {
                throw new AnalysisException("Do not support rename partition name");
            }
        }
        if (this.newTableName.isEmpty()) {
            this.newTableName = this.tableName;
            this.newPartitionName = this.partitionName;
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getNewPartitionName() {
        return this.newPartitionName;
    }

    public boolean onlyTable() {
        return this.partitionName.isEmpty();
    }

    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("`").append(this.tableName).append("`");
        if (!this.partitionName.isEmpty()) {
            sb.append(".`").append(this.partitionName).append("`");
        }
        sb.append(" AS ").append("`").append(this.newTableName).append("`");
        if (!this.partitionName.isEmpty()) {
            sb.append(".`").append(this.newPartitionName).append("`");
        }
        return sb.toString();
    }

    private static void checkIntersectInternal(List<Pair<String, String>> pairs) throws AnalysisException {
        HashMap tablePartitionMap = Maps.newHashMap();
        Pair<String, String> duplicatedObj = null;
        for (Pair<String, String> pair : pairs) {
            String tbl = (String)pair.first;
            String partition = (String)pair.second;
            if (((String)pair.second).isEmpty()) {
                if (tablePartitionMap.containsKey(tbl)) {
                    duplicatedObj = pair;
                    break;
                }
                HashSet emptySet = Sets.newHashSet();
                tablePartitionMap.put(tbl, emptySet);
                continue;
            }
            Set partitions = (Set)tablePartitionMap.get(tbl);
            if (partitions != null) {
                if (partitions.isEmpty()) {
                    duplicatedObj = pair;
                    break;
                }
                if (partitions.contains(partition)) {
                    duplicatedObj = pair;
                    break;
                }
                partitions.add(partition);
                continue;
            }
            partitions = Sets.newHashSet();
            partitions.add(partition);
            tablePartitionMap.put(tbl, partitions);
        }
        if (duplicatedObj != null) {
            throw new AnalysisException("Duplicated restore object: " + duplicatedObj);
        }
    }

    public static void checkIntersect(List<PartitionName> partitionNames) throws AnalysisException {
        ArrayList oldPairs = Lists.newArrayList();
        ArrayList newPairs = Lists.newArrayList();
        HashMap tableRenameMap = Maps.newHashMap();
        for (PartitionName partitionName : partitionNames) {
            Pair<String, String> oldPair = new Pair<String, String>(partitionName.getTableName(), partitionName.getPartitionName());
            oldPairs.add(oldPair);
            Pair<String, String> newPair = new Pair<String, String>(partitionName.getNewTableName(), partitionName.getNewPartitionName());
            newPairs.add(newPair);
            if (tableRenameMap.containsKey(partitionName.getTableName())) {
                if (((String)tableRenameMap.get(partitionName.getTableName())).equals(partitionName.getNewTableName())) continue;
                throw new AnalysisException("Can not rename table again: " + partitionName.getTableName());
            }
            tableRenameMap.put(partitionName.getTableName(), partitionName.getNewTableName());
        }
        PartitionName.checkIntersectInternal(oldPairs);
        PartitionName.checkIntersectInternal(newPairs);
    }

    public String toString() {
        return this.toSql();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TableName) {
            return this.toString().equals(other.toString());
        }
        return false;
    }
}

