/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.doris.analysis.PartitionValue;
import org.apache.doris.common.AnalysisException;

public class PartitionKeyDesc {
    public static final PartitionKeyDesc MAX_VALUE = new PartitionKeyDesc();
    private List<PartitionValue> lowerValues;
    private List<PartitionValue> upperValues;
    private List<List<PartitionValue>> inValues;
    private PartitionKeyValueType partitionKeyValueType = PartitionKeyValueType.LESS_THAN;

    public static PartitionKeyDesc createMaxKeyDesc() {
        return MAX_VALUE;
    }

    private PartitionKeyDesc() {
    }

    public static PartitionKeyDesc createLessThan(List<PartitionValue> upperValues) {
        PartitionKeyDesc desc = new PartitionKeyDesc();
        desc.upperValues = upperValues;
        desc.partitionKeyValueType = PartitionKeyValueType.LESS_THAN;
        return desc;
    }

    public static PartitionKeyDesc createIn(List<List<PartitionValue>> inValues) {
        PartitionKeyDesc desc = new PartitionKeyDesc();
        desc.inValues = inValues;
        desc.partitionKeyValueType = PartitionKeyValueType.IN;
        return desc;
    }

    public static PartitionKeyDesc createFixed(List<PartitionValue> lowerValues, List<PartitionValue> upperValues) {
        PartitionKeyDesc desc = new PartitionKeyDesc();
        desc.lowerValues = lowerValues;
        desc.upperValues = upperValues;
        desc.partitionKeyValueType = PartitionKeyValueType.FIXED;
        return desc;
    }

    public List<PartitionValue> getLowerValues() {
        return this.lowerValues;
    }

    public List<PartitionValue> getUpperValues() {
        return this.upperValues;
    }

    public List<List<PartitionValue>> getInValues() {
        return this.inValues;
    }

    public boolean isMax() {
        return this == MAX_VALUE;
    }

    public boolean hasLowerValues() {
        return this.lowerValues != null;
    }

    public boolean hasUpperValues() {
        return this.upperValues != null;
    }

    public PartitionKeyValueType getPartitionType() {
        return this.partitionKeyValueType;
    }

    public void analyze(int partColNum) throws AnalysisException {
        if (!this.isMax() && this.upperValues != null && (this.upperValues.isEmpty() || this.upperValues.size() > partColNum)) {
            throw new AnalysisException("Partition values number is more than partition column number: " + this.toSql());
        }
        if (this.lowerValues != null && this.lowerValues.size() > 1) {
            for (PartitionValue lowerVal : this.lowerValues) {
                if (!lowerVal.isMax()) continue;
                throw new AnalysisException("Not support MAXVALUE in multi partition range values.");
            }
        }
        if (this.upperValues != null && this.upperValues.size() > 1) {
            for (PartitionValue upperVal : this.upperValues) {
                if (!upperVal.isMax()) continue;
                throw new AnalysisException("Not support MAXVALUE in multi partition range values.");
            }
        }
    }

    public String toSql() {
        if (this.isMax()) {
            return "MAXVALUE";
        }
        if (this.partitionKeyValueType == PartitionKeyValueType.LESS_THAN) {
            return this.getPartitionValuesStr(this.upperValues);
        }
        if (this.partitionKeyValueType == PartitionKeyValueType.FIXED) {
            StringBuilder sb = new StringBuilder("[");
            sb.append(this.getPartitionValuesStr(this.lowerValues)).append(", ").append(this.getPartitionValuesStr(this.upperValues));
            sb.append(")");
            return sb.toString();
        }
        if (this.partitionKeyValueType == PartitionKeyValueType.IN) {
            StringBuilder sb = new StringBuilder("(");
            for (int i = 0; i < this.inValues.size(); ++i) {
                String valueStr = this.getPartitionValuesStr(this.inValues.get(i));
                if (this.inValues.get(i).size() == 1) {
                    valueStr = valueStr.substring(1, valueStr.length() - 1);
                }
                sb.append(valueStr);
                if (i >= this.inValues.size() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        }
        return "INVALID";
    }

    private String getPartitionValuesStr(List<PartitionValue> values) {
        StringBuilder sb = new StringBuilder("(");
        Joiner.on((String)", ").appendTo(sb, (Iterable)Lists.transform(values, (Function)new Function<PartitionValue, String>(){

            public String apply(PartitionValue v) {
                if (v.isMax()) {
                    return v.getStringValue();
                }
                return "'" + v.getStringValue() + "'";
            }
        })).append(")");
        return sb.toString();
    }

    public static enum PartitionKeyValueType {
        INVALID,
        LESS_THAN,
        FIXED,
        IN;

    }
}

