/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.ListPartitionDesc;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.qe.ConnectContext;

public class PartitionDesc {
    protected List<String> partitionColNames;
    protected List<SinglePartitionDesc> singlePartitionDescs;
    protected PartitionType type;

    public PartitionDesc(List<String> partitionColNames, List<SinglePartitionDesc> singlePartitionDescs) {
        this.partitionColNames = partitionColNames;
        this.singlePartitionDescs = singlePartitionDescs;
        if (this.singlePartitionDescs == null) {
            this.singlePartitionDescs = Lists.newArrayList();
        }
    }

    public List<SinglePartitionDesc> getSinglePartitionDescs() {
        return this.singlePartitionDescs;
    }

    public List<String> getPartitionColNames() {
        return this.partitionColNames;
    }

    public void analyze(List<ColumnDef> columnDefs, Map<String, String> otherProperties) throws AnalysisException {
        if (this.partitionColNames == null || this.partitionColNames.isEmpty()) {
            throw new AnalysisException("No partition columns.");
        }
        TreeSet partColNames = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (String partitionCol : this.partitionColNames) {
            if (!partColNames.add(partitionCol)) {
                throw new AnalysisException("Duplicated partition column " + partitionCol);
            }
            boolean found = false;
            for (ColumnDef columnDef : columnDefs) {
                if (!columnDef.getName().equals(partitionCol)) continue;
                if (!columnDef.isKey() && columnDef.getAggregateType() != AggregateType.NONE) {
                    throw new AnalysisException("The partition column could not be aggregated column");
                }
                if (columnDef.getType().isFloatingPointType()) {
                    throw new AnalysisException("Floating point type column can not be partition column");
                }
                if (columnDef.getType().isScalarType(PrimitiveType.STRING)) {
                    throw new AnalysisException("String Type should not be used in partition column[" + columnDef.getName() + "].");
                }
                if (!ConnectContext.get().getSessionVariable().isAllowPartitionColumnNullable() && columnDef.isAllowNull()) {
                    throw new AnalysisException("The partition column must be NOT NULL");
                }
                if (this instanceof ListPartitionDesc && columnDef.isAllowNull()) {
                    throw new AnalysisException("The list partition column must be NOT NULL");
                }
                found = true;
                break;
            }
            if (found) continue;
            throw new AnalysisException("Partition column[" + partitionCol + "] does not exist in column list.");
        }
        TreeSet nameSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (SinglePartitionDesc desc : this.singlePartitionDescs) {
            if (!nameSet.add(desc.getPartitionName())) {
                throw new AnalysisException("Duplicated partition name: " + desc.getPartitionName());
            }
            HashMap givenProperties = null;
            if (otherProperties != null) {
                givenProperties = Maps.newHashMap(otherProperties);
            }
            this.checkPartitionKeyValueType(desc.getPartitionKeyDesc());
            desc.analyze(columnDefs.size(), givenProperties);
        }
    }

    public void checkPartitionKeyValueType(PartitionKeyDesc partitionKeyDesc) throws AnalysisException {
    }

    public PartitionType getType() {
        return this.type;
    }

    public String toSql() {
        throw new NotImplementedException();
    }

    public PartitionInfo toPartitionInfo(List<Column> schema, Map<String, Long> partitionNameToId, boolean isTemp) throws DdlException {
        throw new NotImplementedException();
    }
}

