/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.common.AnalysisException;

public class OrderByElement {
    private Expr expr;
    private final boolean isAsc;
    private final Boolean nullsFirstParam;

    public OrderByElement(Expr expr, boolean isAsc, Boolean nullsFirstParam) {
        this.expr = expr;
        this.isAsc = isAsc;
        this.nullsFirstParam = nullsFirstParam;
    }

    public void setExpr(Expr e) {
        this.expr = e;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public boolean getIsAsc() {
        return this.isAsc;
    }

    public Boolean getNullsFirstParam() {
        return this.nullsFirstParam;
    }

    public OrderByElement clone() {
        OrderByElement clone = new OrderByElement(this.expr.clone(), this.isAsc, this.nullsFirstParam);
        return clone;
    }

    public static List<OrderByElement> reverse(List<OrderByElement> src) {
        ArrayList result = Lists.newArrayListWithCapacity((int)src.size());
        for (int i = 0; i < src.size(); ++i) {
            OrderByElement element = src.get(i);
            OrderByElement reverseElement = new OrderByElement(element.getExpr().clone(), !element.isAsc, !OrderByElement.nullsFirst(element.nullsFirstParam, element.isAsc));
            result.add(reverseElement);
        }
        return result;
    }

    public static List<Expr> getOrderByExprs(List<OrderByElement> src) {
        ArrayList result = Lists.newArrayListWithCapacity((int)src.size());
        for (OrderByElement element : src) {
            result.add(element.getExpr());
        }
        return result;
    }

    public static ArrayList<OrderByElement> substitute(List<OrderByElement> src, ExprSubstitutionMap smap, Analyzer analyzer) throws AnalysisException {
        ArrayList result = Lists.newArrayListWithCapacity((int)src.size());
        for (OrderByElement element : src) {
            result.add(new OrderByElement(element.getExpr().substitute(smap, analyzer, false), element.isAsc, element.nullsFirstParam));
        }
        return result;
    }

    public String toSql() {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(this.expr.toSql());
        strBuilder.append(this.isAsc ? " ASC" : " DESC");
        if (this.nullsFirstParam != null) {
            if (this.isAsc && this.nullsFirstParam.booleanValue()) {
                strBuilder.append(" NULLS FIRST");
            } else if (!this.isAsc && !this.nullsFirstParam.booleanValue()) {
                strBuilder.append(" NULLS LAST");
            }
        }
        return strBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        OrderByElement o = (OrderByElement)obj;
        return this.expr.equals(o.expr) && this.isAsc == o.isAsc && this.nullsFirstParam == o.nullsFirstParam;
    }

    public static boolean nullsFirst(Boolean nullsFirstParam, boolean isAsc) {
        return nullsFirstParam == null ? !isAsc : nullsFirstParam;
    }
}

