/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;

public class NullLiteral
extends LiteralExpr {
    private static final LiteralExpr INT_EXPR;

    public NullLiteral() {
        this.type = Type.NULL;
    }

    public static NullLiteral create(Type type) {
        NullLiteral l = new NullLiteral();
        l.type = type;
        return l;
    }

    protected NullLiteral(NullLiteral other) {
        super(other);
    }

    @Override
    protected void resetAnalysisState() {
        super.resetAnalysisState();
        this.type = Type.NULL;
    }

    @Override
    public Expr clone() {
        return new NullLiteral(this);
    }

    @Override
    public boolean isMinValue() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return obj instanceof NullLiteral;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 0;
        }
        return -1;
    }

    @Override
    public String toSqlImpl() {
        return this.getStringValue();
    }

    @Override
    public String getStringValue() {
        return "NULL";
    }

    @Override
    public long getLongValue() {
        return 0L;
    }

    @Override
    public double getDoubleValue() {
        return 0.0;
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        return INT_EXPR.getHashValue(PrimitiveType.INT);
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        Preconditions.checkState((boolean)targetType.isValid());
        if (!this.type.equals(targetType)) {
            NullLiteral nullLiteral = new NullLiteral(this);
            nullLiteral.setType(targetType);
            return nullLiteral;
        }
        return this;
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.NULL_LITERAL;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
    }

    public static NullLiteral read(DataInput in) throws IOException {
        NullLiteral literal = new NullLiteral();
        literal.readFields(in);
        return literal;
    }

    static {
        try {
            INT_EXPR = new IntLiteral("0", (Type)Type.INT);
        }
        catch (AnalysisException e) {
            throw new RuntimeException(e);
        }
    }
}

