/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.catalog.TableProperty;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.DynamicPartitionUtil;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.PropertyAnalyzer;

public class ModifyTablePropertiesClause
extends AlterTableClause {
    private Map<String, String> properties;

    public ModifyTablePropertiesClause(Map<String, String> properties) {
        super(AlterOpType.MODIFY_TABLE_PROPERTY);
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.properties == null || this.properties.isEmpty()) {
            throw new AnalysisException("Properties is not set");
        }
        if (this.properties.size() != 1 && !TableProperty.isSamePrefixProperties(this.properties, "dynamic_partition")) {
            throw new AnalysisException("Can only set one table property at a time");
        }
        if (this.properties.containsKey("colocate_with")) {
            this.needTableStable = false;
        } else if (this.properties.containsKey("storage_type")) {
            if (!this.properties.get("storage_type").equalsIgnoreCase("column")) {
                throw new AnalysisException("Can only change storage type to COLUMN");
            }
        } else if (this.properties.containsKey("distribution_type")) {
            if (!this.properties.get("distribution_type").equalsIgnoreCase("random")) {
                throw new AnalysisException("Can only change distribution type from HASH to RANDOM");
            }
            this.needTableStable = false;
        } else if (this.properties.containsKey("send_clear_alter_tasks")) {
            if (!this.properties.get("send_clear_alter_tasks").equalsIgnoreCase("true")) {
                throw new AnalysisException("Property send_clear_alter_tasks should be set to true");
            }
            this.needTableStable = false;
        } else if (!this.properties.containsKey("bloom_filter_columns") && !this.properties.containsKey("bloom_filter_fpp")) {
            if (this.properties.containsKey("storage_format")) {
                if (!this.properties.get("storage_format").equalsIgnoreCase("v2")) {
                    throw new AnalysisException("Property storage_format should be v2");
                }
            } else if (!DynamicPartitionUtil.checkDynamicPartitionPropertiesExist(this.properties)) {
                if (this.properties.containsKey("replication_num") || this.properties.containsKey("replication_allocation")) {
                    ReplicaAllocation replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(this.properties, "");
                    this.properties.put("replication_allocation", replicaAlloc.toCreateStmt());
                } else if (this.properties.containsKey("default.replication_num") || this.properties.containsKey("default.replication_allocation")) {
                    ReplicaAllocation replicaAlloc = PropertyAnalyzer.analyzeReplicaAllocation(this.properties, "default");
                    this.properties.put("default.replication_allocation", replicaAlloc.toCreateStmt());
                } else if (this.properties.containsKey("in_memory")) {
                    this.needTableStable = false;
                    this.opType = AlterOpType.MODIFY_TABLE_PROPERTY_SYNC;
                } else {
                    if (this.properties.containsKey("tablet_type")) {
                        throw new AnalysisException("Alter tablet type not supported");
                    }
                    throw new AnalysisException("Unknown table property: " + this.properties.keySet());
                }
            }
        }
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("PROPERTIES (");
        sb.append(new PrintableMap<String, String>(this.properties, "=", true, false));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

