/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModifyTableCommentClause
extends AlterTableClause {
    private static final Logger LOG = LogManager.getLogger(ModifyTableCommentClause.class);
    private String comment;

    public ModifyTableCommentClause(String comment) {
        super(AlterOpType.MODIFY_TABLE_COMMENT);
        this.comment = Strings.nullToEmpty((String)comment);
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
    }

    @Override
    public Map<String, String> getProperties() {
        return Maps.newHashMap();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("MODIFY COMMENT ");
        sb.append("'").append(this.comment).append("'");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

