/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.PropertyAnalyzer;

public class ModifyPartitionClause
extends AlterTableClause {
    private List<String> partitionNames;
    private Map<String, String> properties;
    private boolean needExpand = false;

    public List<String> getPartitionNames() {
        return this.partitionNames;
    }

    public ModifyPartitionClause(List<String> partitionNames, Map<String, String> properties) {
        super(AlterOpType.MODIFY_PARTITION);
        this.partitionNames = partitionNames;
        this.properties = properties;
        this.needExpand = false;
        this.needTableStable = false;
    }

    private ModifyPartitionClause(Map<String, String> properties) {
        super(AlterOpType.MODIFY_PARTITION);
        this.partitionNames = Lists.newArrayList();
        this.properties = properties;
        this.needExpand = true;
        this.needTableStable = false;
    }

    public static ModifyPartitionClause createStarClause(Map<String, String> properties) {
        return new ModifyPartitionClause(properties);
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.partitionNames == null || !this.needExpand && this.partitionNames.isEmpty()) {
            throw new AnalysisException("Partition names is not set or empty");
        }
        if (this.partitionNames.stream().anyMatch(entity -> Strings.isNullOrEmpty((String)entity))) {
            throw new AnalysisException("there are empty partition name");
        }
        if (this.properties == null || this.properties.isEmpty()) {
            throw new AnalysisException("Properties is not set");
        }
        this.checkProperties(Maps.newHashMap(this.properties));
    }

    private void checkProperties(Map<String, String> properties) throws AnalysisException {
        DataProperty newDataProperty = null;
        newDataProperty = PropertyAnalyzer.analyzeDataProperty(properties, DataProperty.DEFAULT_DATA_PROPERTY);
        Preconditions.checkNotNull((Object)newDataProperty);
        PropertyAnalyzer.analyzeReplicaAllocation(properties, "");
        PropertyAnalyzer.analyzeBooleanProp(properties, "in_memory", false);
        PropertyAnalyzer.analyzeTabletType(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isNeedExpand() {
        return this.needExpand;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("MODIFY PARTITION ");
        sb.append("(");
        if (this.needExpand) {
            sb.append("*");
        } else {
            sb.append(Joiner.on((String)", ").join(this.partitionNames));
        }
        sb.append(")");
        sb.append(" SET (");
        sb.append(new PrintableMap<String, String>(this.properties, "=", true, false));
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

