/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModifyEngineClause
extends AlterTableClause {
    private static final Logger LOG = LogManager.getLogger(ModifyEngineClause.class);
    private String engine;
    private Map<String, String> properties;

    public ModifyEngineClause(String engine, Map<String, String> properties) {
        super(AlterOpType.MODIFY_ENGINE);
        this.engine = engine;
        this.properties = properties;
    }

    public String getEngine() {
        return this.engine;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.engine)) {
            throw new AnalysisException("Engine name is missing");
        }
        if (!this.engine.equalsIgnoreCase(Table.TableType.ODBC.name())) {
            throw new AnalysisException("Only support alter table engine from MySQL to ODBC");
        }
        if (this.properties == null || !this.properties.containsKey("driver")) {
            throw new AnalysisException("Need specify 'driver' property");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("MODIFY ENGINE TO ").append(this.engine);
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

