/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModifyColumnCommentClause
extends AlterTableClause {
    private static final Logger LOG = LogManager.getLogger(ModifyColumnCommentClause.class);
    private String colName;
    private String comment;

    public ModifyColumnCommentClause(String colName, String comment) {
        super(AlterOpType.MODIFY_COLUMN_COMMENT);
        this.colName = colName;
        this.comment = Strings.nullToEmpty((String)comment);
    }

    public String getColName() {
        return this.colName;
    }

    public String getComment() {
        return this.comment;
    }

    @Override
    public Map<String, String> getProperties() {
        return Maps.newHashMap();
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.colName)) {
            throw new AnalysisException("Empty column name");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("MODIFY COLUMN COMMENT ").append(this.colName);
        sb.append(" '").append(this.comment).append("'");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

