/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.Map;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterTableClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.ColumnPosition;
import org.apache.doris.catalog.Column;
import org.apache.doris.common.AnalysisException;

public class ModifyColumnClause
extends AlterTableClause {
    private ColumnDef columnDef;
    private ColumnPosition colPos;
    private String rollupName;
    private Map<String, String> properties;
    private Column column;

    public Column getColumn() {
        return this.column;
    }

    public ColumnPosition getColPos() {
        return this.colPos;
    }

    public String getRollupName() {
        return this.rollupName;
    }

    public ModifyColumnClause(ColumnDef columnDef, ColumnPosition colPos, String rollup, Map<String, String> properties) {
        super(AlterOpType.SCHEMA_CHANGE);
        this.columnDef = columnDef;
        this.colPos = colPos;
        this.rollupName = rollup;
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (this.columnDef == null) {
            throw new AnalysisException("No column definition in modify column clause.");
        }
        this.columnDef.analyze(true);
        if (this.colPos != null) {
            this.colPos.analyze();
        }
        if (Strings.isNullOrEmpty((String)this.rollupName)) {
            this.rollupName = null;
        }
        this.column = this.columnDef.toColumn();
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("MODIFY COLUMN ").append(this.columnDef.toSql());
        if (this.colPos != null) {
            sb.append(" ").append(this.colPos);
        }
        if (this.rollupName != null) {
            sb.append(" IN `").append(this.rollupName).append("`");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

