/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;
import org.apache.doris.alter.AlterOpType;
import org.apache.doris.analysis.AlterClause;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.system.SystemInfoService;

public class ModifyBrokerClause
extends AlterClause {
    private final ModifyOp op;
    private final String brokerName;
    private final List<String> hostPorts;
    protected Set<Pair<String, Integer>> hostPortPairs;

    public ModifyBrokerClause(ModifyOp op, String brokerName, List<String> hostPorts) {
        super(AlterOpType.ALTER_OTHER);
        this.op = op;
        this.brokerName = brokerName;
        this.hostPorts = hostPorts;
    }

    public static ModifyBrokerClause createAddBrokerClause(String brokerName, List<String> hostPorts) {
        return new ModifyBrokerClause(ModifyOp.OP_ADD, brokerName, hostPorts);
    }

    public static ModifyBrokerClause createDropBrokerClause(String brokerName, List<String> hostPorts) {
        return new ModifyBrokerClause(ModifyOp.OP_DROP, brokerName, hostPorts);
    }

    public static ModifyBrokerClause createDropAllBrokerClause(String brokerName) {
        return new ModifyBrokerClause(ModifyOp.OP_DROP_ALL, brokerName, null);
    }

    public ModifyOp getOp() {
        return this.op;
    }

    public String getBrokerName() {
        return this.brokerName;
    }

    public Set<Pair<String, Integer>> getHostPortPairs() {
        return this.hostPortPairs;
    }

    private void validateBrokerName() throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.brokerName)) {
            throw new AnalysisException("Broker's name can't be empty.");
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.validateBrokerName();
        if (this.op != ModifyOp.OP_DROP_ALL) {
            this.hostPortPairs = Sets.newHashSet();
            for (String hostPort : this.hostPorts) {
                Pair<String, Integer> pair = SystemInfoService.validateHostAndPort(hostPort);
                this.hostPortPairs.add(pair);
            }
            Preconditions.checkState((!this.hostPortPairs.isEmpty() ? 1 : 0) != 0);
        }
    }

    @Override
    public String toSql() {
        throw new NotImplementedException();
    }

    @Override
    public Map<String, String> getProperties() {
        throw new NotImplementedException();
    }

    public static enum ModifyOp {
        OP_ADD,
        OP_DROP,
        OP_DROP_ALL;

    }
}

