/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BackendClause;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.util.PropertyAnalyzer;
import org.apache.doris.resource.Tag;

public class ModifyBackendClause
extends BackendClause {
    protected Map<String, String> properties = Maps.newHashMap();
    protected Map<String, String> analyzedProperties = Maps.newHashMap();
    private Tag tag = null;
    private Boolean isQueryDisabled = null;
    private Boolean isLoadDisabled = null;

    public ModifyBackendClause(List<String> hostPorts, Map<String, String> properties) {
        super(hostPorts);
        this.properties = properties;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        super.analyze(analyzer);
        this.tag = PropertyAnalyzer.analyzeBackendTagProperties(this.properties, null);
        this.isQueryDisabled = PropertyAnalyzer.analyzeBackendDisableProperties(this.properties, "disable_query", null);
        this.isLoadDisabled = PropertyAnalyzer.analyzeBackendDisableProperties(this.properties, "disable_load", null);
        if (this.tag != null) {
            this.analyzedProperties.put(this.tag.type, this.tag.value);
        }
        if (this.isQueryDisabled != null) {
            this.analyzedProperties.put("disable_query", String.valueOf(this.isQueryDisabled));
        }
        if (this.isLoadDisabled != null) {
            this.analyzedProperties.put("disable_load", String.valueOf(this.isLoadDisabled));
        }
        if (!this.properties.isEmpty()) {
            throw new AnalysisException("unknown properties setting for key (" + StringUtils.join(this.properties.keySet(), (String)",") + ")");
        }
    }

    public Tag getTag() {
        return this.tag;
    }

    public Boolean isQueryDisabled() {
        return this.isQueryDisabled;
    }

    public Boolean isLoadDisabled() {
        return this.isLoadDisabled;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("MODIFY BACKEND ");
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            sb.append("\"").append((String)this.hostPorts.get(i)).append("\"");
            if (i == this.hostPorts.size() - 1) continue;
            sb.append(", ");
        }
        sb.append(" SET (");
        for (String key : this.analyzedProperties.keySet()) {
            sb.append("\"").append(key).append("\"=\"");
            sb.append(this.analyzedProperties.get(this.analyzedProperties.get(key))).append("\",");
        }
        if (!this.analyzedProperties.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(")");
        return sb.toString();
    }
}

