/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.ClusterName;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;

@Deprecated
public class MigrateDbStmt
extends DdlStmt {
    private ClusterName src;
    private ClusterName dest;
    private String srcCluster;
    private String destCluster;
    private String srcDb;
    private String destDb;

    MigrateDbStmt(ClusterName src, ClusterName dest) {
        this.src = src;
        this.dest = dest;
    }

    public String getSrcCluster() {
        return this.srcCluster;
    }

    public String getDestCluster() {
        return this.destCluster;
    }

    public String getSrcDb() {
        return this.srcDb;
    }

    public String getDestDb() {
        return this.destDb;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException, UserException {
        if (Config.disable_cluster_feature) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_INVALID_OPERATION, "MIGRATION CLUSTER");
        }
        this.src.analyze(analyzer);
        this.dest.analyze(analyzer);
        if (!Catalog.getCurrentCatalog().getAuth().checkGlobalPriv(ConnectContext.get(), PrivPredicate.ADMIN)) {
            ErrorReport.reportAnalysisException(ErrorCode.ERR_SPECIFIC_ACCESS_DENIED_ERROR, "ADMIN");
        }
        this.srcCluster = this.src.getCluster();
        this.srcDb = ClusterNamespace.getFullName(this.srcCluster, this.src.getDb());
        this.destCluster = this.dest.getCluster();
        this.destDb = ClusterNamespace.getFullName(this.destCluster, this.dest.getDb());
    }

    @Override
    public String toSql() {
        return "MIGRATE DATABASE " + this.srcCluster + "." + this.srcDb + " " + this.destCluster + "." + this.destDb;
    }

    public String toString() {
        return this.toSql();
    }
}

