/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.MVColumnPattern;

public class MVColumnOneChildPattern
implements MVColumnPattern {
    private String functionName;

    public MVColumnOneChildPattern(String functionName) {
        this.functionName = functionName;
    }

    @Override
    public boolean match(Expr expr) {
        if (!(expr instanceof FunctionCallExpr)) {
            return false;
        }
        FunctionCallExpr functionCallExpr = (FunctionCallExpr)expr;
        if (functionCallExpr.isDistinct()) {
            return false;
        }
        String exprFnName = functionCallExpr.getFnName().getFunction();
        if (!exprFnName.equalsIgnoreCase(this.functionName)) {
            return false;
        }
        if (functionCallExpr.getChildren().size() != 1) {
            return false;
        }
        return ((Expr)functionCallExpr.getChild(0)).unwrapSlotRef() != null;
    }

    public String toString() {
        return this.functionName + "(column)";
    }
}

