/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import org.apache.doris.analysis.ColumnDef;
import org.apache.doris.analysis.Expr;
import org.apache.doris.catalog.AggregateType;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.DdlException;

public class MVColumnItem {
    private String name;
    private Type type;
    private boolean isKey;
    private AggregateType aggregationType;
    private boolean isAggregationTypeImplicit;
    private Expr defineExpr;
    private String baseColumnName;

    public MVColumnItem(String name, Type type, AggregateType aggregateType, boolean isAggregationTypeImplicit, Expr defineExpr, String baseColumnName) {
        this.name = name;
        this.type = type;
        this.aggregationType = aggregateType;
        this.isAggregationTypeImplicit = isAggregationTypeImplicit;
        this.defineExpr = defineExpr;
        this.baseColumnName = baseColumnName;
    }

    public MVColumnItem(String name, Type type) {
        this.name = name;
        this.type = type;
        this.baseColumnName = name;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setIsKey(boolean key) {
        this.isKey = key;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setAggregationType(AggregateType aggregationType, boolean isAggregationTypeImplicit) {
        this.aggregationType = aggregationType;
        this.isAggregationTypeImplicit = isAggregationTypeImplicit;
    }

    public AggregateType getAggregationType() {
        return this.aggregationType;
    }

    public boolean isAggregationTypeImplicit() {
        return this.isAggregationTypeImplicit;
    }

    public Expr getDefineExpr() {
        return this.defineExpr;
    }

    public void setDefineExpr(Expr defineExpr) {
        this.defineExpr = defineExpr;
    }

    public String getBaseColumnName() {
        return this.baseColumnName;
    }

    public Column toMVColumn(OlapTable olapTable) throws DdlException {
        Column baseColumn = olapTable.getBaseColumn(this.name);
        if (baseColumn == null) {
            Preconditions.checkNotNull((Object)(this.defineExpr != null ? 1 : 0));
            Column result = new Column(this.name, this.type, this.isKey, this.aggregationType, ColumnDef.DefaultValue.ZERO, "");
            result.setDefineExpr(this.defineExpr);
            return result;
        }
        Column result = new Column(baseColumn);
        result.setIsKey(this.isKey);
        result.setAggregationType(this.aggregationType, this.isAggregationTypeImplicit);
        return result;
    }
}

