/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.MVColumnPattern;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;

public class MVColumnHLLUnionPattern
implements MVColumnPattern {
    @Override
    public boolean match(Expr expr) {
        if (!(expr instanceof FunctionCallExpr)) {
            return false;
        }
        FunctionCallExpr fnExpr = (FunctionCallExpr)expr;
        if (fnExpr.isDistinct()) {
            return false;
        }
        String fnNameString = fnExpr.getFnName().getFunction();
        if (!fnNameString.equalsIgnoreCase("hll_union")) {
            return false;
        }
        if (fnExpr.getChild(0) instanceof SlotRef) {
            SlotRef slotRef = (SlotRef)fnExpr.getChild(0);
            return slotRef.getType().getPrimitiveType() == PrimitiveType.HLL && slotRef.getColumn() != null;
        }
        if (fnExpr.getChild(0) instanceof FunctionCallExpr) {
            FunctionCallExpr child0FnExpr = (FunctionCallExpr)fnExpr.getChild(0);
            if (!child0FnExpr.getFnName().getFunction().equalsIgnoreCase("hll_hash")) {
                return false;
            }
            SlotRef slotRef = ((Expr)child0FnExpr.getChild(0)).unwrapSlotRef();
            if (slotRef == null) {
                return false;
            }
            return slotRef.getType() != Type.DECIMALV2;
        }
        return false;
    }

    public String toString() {
        return "hll_union(hll_hash(column)) column could not be decimal. Or hll_union(hll_column) in agg table";
    }
}

