/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.MVColumnPattern;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.PrimitiveType;

public class MVColumnBitmapUnionPattern
implements MVColumnPattern {
    @Override
    public boolean match(Expr expr) {
        if (!(expr instanceof FunctionCallExpr)) {
            return false;
        }
        FunctionCallExpr fnExpr = (FunctionCallExpr)expr;
        if (fnExpr.isDistinct()) {
            return false;
        }
        String fnNameString = fnExpr.getFnName().getFunction();
        if (!fnNameString.equalsIgnoreCase("bitmap_union")) {
            return false;
        }
        if (fnExpr.getChild(0) instanceof SlotRef) {
            SlotRef slotRef = (SlotRef)fnExpr.getChild(0);
            return slotRef.getType().getPrimitiveType() == PrimitiveType.BITMAP && slotRef.getColumn() != null;
        }
        if (fnExpr.getChild(0) instanceof FunctionCallExpr) {
            FunctionCallExpr child0FnExpr = (FunctionCallExpr)fnExpr.getChild(0);
            if (!child0FnExpr.getFnName().getFunction().equalsIgnoreCase("to_bitmap")) {
                return false;
            }
            SlotRef slotRef = ((Expr)child0FnExpr.getChild(0)).unwrapSlotRef();
            if (slotRef == null) {
                return false;
            }
            return slotRef.getType().isIntegerType();
        }
        return false;
    }

    public String toString() {
        return "bitmap_union(to_bitmap(column)), type of column could not be integer. Or bitmap_union(bitmap_column) in agg table";
    }
}

