/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.LockTable;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.StatementBase;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.Table;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.UserException;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LockTablesStmt
extends StatementBase {
    private static final Logger LOG = LogManager.getLogger(LockTablesStmt.class);
    private List<LockTable> lockTables;

    public LockTablesStmt(ArrayList<LockTable> lockTables) {
        this.lockTables = lockTables;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        for (LockTable lockTable : this.lockTables) {
            String dbName = lockTable.getTableName().getDb();
            String tableName = lockTable.getTableName().getTbl();
            if (Strings.isNullOrEmpty((String)(dbName = Strings.isNullOrEmpty((String)dbName) ? analyzer.getDefaultDb() : ClusterNamespace.getFullName(analyzer.getClusterName(), dbName)))) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            if (Strings.isNullOrEmpty((String)tableName)) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_UNKNOWN_TABLE, tableName, dbName);
            }
            Database db = analyzer.getCatalog().getDbOrAnalysisException(dbName);
            Table table = db.getTableOrAnalysisException(tableName);
            if (Catalog.getCurrentCatalog().getAuth().checkTblPriv(ConnectContext.get(), dbName, tableName, PrivPredicate.SELECT)) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_TABLEACCESS_DENIED_ERROR, "SELECT", ConnectContext.get().getQualifiedUser(), ConnectContext.get().getRemoteIP(), dbName + ": " + tableName);
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("LOCK TABLES ");
        for (int i = 0; i < this.lockTables.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.lockTables.get(i).getTableName().toSql());
            if (this.lockTables.get(i).getAlias() != null) {
                sb.append(" AS ").append(this.lockTables.get(i).getAlias());
            }
            sb.append(" ").append(this.lockTables.get(i).getLockType().toString());
        }
        return sb.toString();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.NO_FORWARD;
    }
}

