/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.DataDescription;
import org.apache.doris.analysis.DdlStmt;
import org.apache.doris.analysis.ExportStmt;
import org.apache.doris.analysis.LabelName;
import org.apache.doris.analysis.ResourceDesc;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.KeysType;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.PrintableMap;
import org.apache.doris.common.util.TimeUtils;
import org.apache.doris.load.EtlJobType;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.qe.ConnectContext;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LoadStmt
extends DdlStmt {
    public static final String TIMEOUT_PROPERTY = "timeout";
    public static final String MAX_FILTER_RATIO_PROPERTY = "max_filter_ratio";
    public static final String EXEC_MEM_LIMIT = "exec_mem_limit";
    public static final String CLUSTER_PROPERTY = "cluster";
    public static final String STRICT_MODE = "strict_mode";
    public static final String TIMEZONE = "timezone";
    public static final String LOAD_PARALLELISM = "load_parallelism";
    public static final String SEND_BATCH_PARALLELISM = "send_batch_parallelism";
    public static final String LOAD_TO_SINGLE_TABLET = "load_to_single_tablet";
    public static final String BOS_ENDPOINT = "bos_endpoint";
    public static final String BOS_ACCESSKEY = "bos_accesskey";
    public static final String BOS_SECRET_ACCESSKEY = "bos_secret_accesskey";
    public static final String KEY_IN_PARAM_COLUMNS = "columns";
    public static final String KEY_IN_PARAM_SET = "set";
    public static final String KEY_IN_PARAM_HLL = "hll";
    public static final String KEY_IN_PARAM_COLUMN_SEPARATOR = "column_separator";
    public static final String KEY_IN_PARAM_LINE_DELIMITER = "line_delimiter";
    public static final String KEY_IN_PARAM_PARTITIONS = "partitions";
    public static final String KEY_IN_PARAM_FORMAT_TYPE = "format";
    public static final String KEY_IN_PARAM_WHERE = "where";
    public static final String KEY_IN_PARAM_MAX_FILTER_RATIO = "max_filter_ratio";
    public static final String KEY_IN_PARAM_TIMEOUT = "timeout";
    public static final String KEY_IN_PARAM_TEMP_PARTITIONS = "temporary_partitions";
    public static final String KEY_IN_PARAM_NEGATIVE = "negative";
    public static final String KEY_IN_PARAM_STRICT_MODE = "strict_mode";
    public static final String KEY_IN_PARAM_TIMEZONE = "timezone";
    public static final String KEY_IN_PARAM_EXEC_MEM_LIMIT = "exec_mem_limit";
    public static final String KEY_IN_PARAM_JSONPATHS = "jsonpaths";
    public static final String KEY_IN_PARAM_JSONROOT = "json_root";
    public static final String KEY_IN_PARAM_STRIP_OUTER_ARRAY = "strip_outer_array";
    public static final String KEY_IN_PARAM_FUZZY_PARSE = "fuzzy_parse";
    public static final String KEY_IN_PARAM_NUM_AS_STRING = "num_as_string";
    public static final String KEY_IN_PARAM_MERGE_TYPE = "merge_type";
    public static final String KEY_IN_PARAM_DELETE_CONDITION = "delete";
    public static final String KEY_IN_PARAM_FUNCTION_COLUMN = "function_column";
    public static final String KEY_IN_PARAM_SEQUENCE_COL = "sequence_col";
    public static final String KEY_IN_PARAM_BACKEND_ID = "backend_id";
    private final LabelName label;
    private final List<DataDescription> dataDescriptions;
    private final BrokerDesc brokerDesc;
    private final String cluster;
    private final ResourceDesc resourceDesc;
    private final Map<String, String> properties;
    private String user;
    private EtlJobType etlJobType = EtlJobType.UNKNOWN;
    public static final ImmutableMap<String, Function> PROPERTIES_MAP = new ImmutableMap.Builder().put((Object)"timeout", (Object)new Function<String, Long>(){

        public @Nullable Long apply(@Nullable String s) {
            return Long.valueOf(s);
        }
    }).put((Object)"max_filter_ratio", (Object)new Function<String, Double>(){

        public @Nullable Double apply(@Nullable String s) {
            return Double.valueOf(s);
        }
    }).put((Object)"exec_mem_limit", (Object)new Function<String, Long>(){

        public @Nullable Long apply(@Nullable String s) {
            return Long.valueOf(s);
        }
    }).put((Object)"strict_mode", (Object)new Function<String, Boolean>(){

        public @Nullable Boolean apply(@Nullable String s) {
            return Boolean.valueOf(s);
        }
    }).put((Object)"timezone", (Object)new Function<String, String>(){

        public @Nullable String apply(@Nullable String s) {
            return s;
        }
    }).put((Object)"load_parallelism", (Object)new Function<String, Integer>(){

        public @Nullable Integer apply(@Nullable String s) {
            return Integer.valueOf(s);
        }
    }).put((Object)"send_batch_parallelism", (Object)new Function<String, Integer>(){

        public @Nullable Integer apply(@Nullable String s) {
            return Integer.valueOf(s);
        }
    }).put((Object)"cluster", (Object)new Function<String, String>(){

        public @Nullable String apply(@Nullable String s) {
            return s;
        }
    }).put((Object)"load_to_single_tablet", (Object)new Function<String, Boolean>(){

        public @Nullable Boolean apply(@Nullable String s) {
            return Boolean.valueOf(s);
        }
    }).build();

    public LoadStmt(LabelName label, List<DataDescription> dataDescriptions, BrokerDesc brokerDesc, String cluster, Map<String, String> properties) {
        this.label = label;
        this.dataDescriptions = dataDescriptions;
        this.brokerDesc = brokerDesc;
        this.cluster = cluster;
        this.resourceDesc = null;
        this.properties = properties;
        this.user = null;
    }

    public LoadStmt(LabelName label, List<DataDescription> dataDescriptions, ResourceDesc resourceDesc, Map<String, String> properties) {
        this.label = label;
        this.dataDescriptions = dataDescriptions;
        this.brokerDesc = null;
        this.cluster = null;
        this.resourceDesc = resourceDesc;
        this.properties = properties;
        this.user = null;
    }

    public LabelName getLabel() {
        return this.label;
    }

    public List<DataDescription> getDataDescriptions() {
        return this.dataDescriptions;
    }

    public BrokerDesc getBrokerDesc() {
        return this.brokerDesc;
    }

    public String getCluster() {
        return this.cluster;
    }

    public ResourceDesc getResourceDesc() {
        return this.resourceDesc;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getUser() {
        return this.user;
    }

    public EtlJobType getEtlJobType() {
        return this.etlJobType;
    }

    public static void checkProperties(Map<String, String> properties) throws DdlException {
        String sendBatchParallelism;
        String strictModeProperty;
        String maxFilterRadioProperty;
        String timeoutLimitProperty;
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (PROPERTIES_MAP.containsKey((Object)entry.getKey())) continue;
            throw new DdlException(entry.getKey() + " is invalid property");
        }
        String execMemProperty = properties.get("exec_mem_limit");
        if (execMemProperty != null) {
            try {
                long execMem = Long.valueOf(execMemProperty);
                if (execMem <= 0L) {
                    throw new DdlException("exec_mem_limit must be greater than 0");
                }
            }
            catch (NumberFormatException e) {
                throw new DdlException("exec_mem_limit is not a number.");
            }
        }
        if ((timeoutLimitProperty = properties.get("timeout")) != null) {
            try {
                int timeoutLimit = Integer.valueOf(timeoutLimitProperty);
                if (timeoutLimit < 0) {
                    throw new DdlException("timeout must be greater than 0");
                }
            }
            catch (NumberFormatException e) {
                throw new DdlException("timeout is not a number.");
            }
        }
        if ((maxFilterRadioProperty = properties.get("max_filter_ratio")) != null) {
            try {
                double maxFilterRatio = Double.valueOf(maxFilterRadioProperty);
                if (maxFilterRatio < 0.0 || maxFilterRatio > 1.0) {
                    throw new DdlException("max_filter_ratio must between 0.0 and 1.0.");
                }
            }
            catch (NumberFormatException e) {
                throw new DdlException("max_filter_ratio is not a number.");
            }
        }
        if ((strictModeProperty = properties.get("strict_mode")) != null && !strictModeProperty.equalsIgnoreCase("true") && !strictModeProperty.equalsIgnoreCase("false")) {
            throw new DdlException("strict_mode is not a boolean");
        }
        String timezone = properties.get("timezone");
        if (timezone != null) {
            properties.put("timezone", TimeUtils.checkTimeZoneValidAndStandardize(properties.getOrDefault("timezone", "Asia/Shanghai")));
        }
        if ((sendBatchParallelism = properties.get(SEND_BATCH_PARALLELISM)) != null) {
            try {
                int sendBatchParallelismValue = Integer.valueOf(sendBatchParallelism);
                if (sendBatchParallelismValue < 1) {
                    throw new DdlException("send_batch_parallelism must be greater than 0");
                }
            }
            catch (NumberFormatException e) {
                throw new DdlException("send_batch_parallelism is not a number.");
            }
        }
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        super.analyze(analyzer);
        this.label.analyze(analyzer);
        if (this.dataDescriptions == null || this.dataDescriptions.isEmpty()) {
            throw new AnalysisException("No data file in load statement.");
        }
        boolean isLoadFromTable = false;
        for (DataDescription dataDescription : this.dataDescriptions) {
            if (this.brokerDesc == null && this.resourceDesc == null) {
                dataDescription.setIsHadoopLoad(true);
            }
            dataDescription.analyze(this.label.getDbName());
            if (dataDescription.isLoadFromTable()) {
                isLoadFromTable = true;
            }
            Database db = Catalog.getCurrentCatalog().getDbOrAnalysisException(this.label.getDbName());
            OlapTable table = db.getOlapTableOrAnalysisException(dataDescription.getTableName());
            if (dataDescription.getMergeType() != LoadTask.MergeType.APPEND && table.getKeysType() != KeysType.UNIQUE_KEYS) {
                throw new AnalysisException("load by MERGE or DELETE is only supported in unique tables.");
            }
            if (dataDescription.getMergeType() != LoadTask.MergeType.APPEND && !table.hasDeleteSign()) {
                throw new AnalysisException("load by MERGE or DELETE need to upgrade table to support batch delete.");
            }
            if (this.brokerDesc == null || this.brokerDesc.isMultiLoadBroker()) continue;
            for (int i = 0; i < dataDescription.getFilePaths().size(); ++i) {
                dataDescription.getFilePaths().set(i, this.brokerDesc.convertPathToS3(dataDescription.getFilePaths().get(i)));
                dataDescription.getFilePaths().set(i, ExportStmt.checkPath(dataDescription.getFilePaths().get(i), this.brokerDesc.getStorageType()));
            }
        }
        if (isLoadFromTable) {
            if (this.dataDescriptions.size() > 1) {
                throw new AnalysisException("Only support one olap table load from one external table");
            }
            if (this.resourceDesc == null) {
                throw new AnalysisException("Load from table should use Spark Load");
            }
        }
        if (this.resourceDesc != null) {
            this.resourceDesc.analyze();
            this.etlJobType = this.resourceDesc.getEtlJobType();
            if (!Config.enable_spark_load) {
                throw new AnalysisException("Spark Load is coming soon");
            }
            if (!Catalog.getCurrentCatalog().getAuth().checkResourcePriv(ConnectContext.get(), this.resourceDesc.getName(), PrivPredicate.USAGE)) {
                throw new AnalysisException("USAGE denied to user '" + ConnectContext.get().getQualifiedUser() + "'@'" + ConnectContext.get().getRemoteIP() + "' for resource '" + this.resourceDesc.getName() + "'");
            }
        } else {
            this.etlJobType = this.brokerDesc != null ? EtlJobType.BROKER : EtlJobType.HADOOP;
        }
        try {
            LoadStmt.checkProperties(this.properties);
        }
        catch (DdlException e) {
            throw new AnalysisException(e.getMessage());
        }
        this.user = ConnectContext.get().getQualifiedUser();
    }

    @Override
    public boolean needAuditEncryption() {
        return this.brokerDesc != null || this.resourceDesc != null;
    }

    public void setEtlJobType(EtlJobType etlJobType) {
        this.etlJobType = etlJobType;
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("LOAD LABEL ").append(this.label.toSql()).append("\n");
        sb.append("(");
        Joiner.on((String)",\n").appendTo(sb, (Iterable)Lists.transform(this.dataDescriptions, (Function)new Function<DataDescription, Object>(){

            public Object apply(DataDescription dataDescription) {
                return dataDescription.toSql();
            }
        })).append(")");
        if (this.brokerDesc != null) {
            sb.append("\n").append(this.brokerDesc.toSql());
        }
        if (this.cluster != null) {
            sb.append("\nBY '");
            sb.append(this.cluster);
            sb.append("'");
        }
        if (this.resourceDesc != null) {
            sb.append("\n").append(this.resourceDesc.toSql());
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            sb.append("\nPROPERTIES (");
            sb.append(new PrintableMap<String, String>(this.properties, "=", true, false));
            sb.append(")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }
}

