/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.ParseNode;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.Pair;

public class LoadColumnsInfo
implements ParseNode {
    private final List<String> columnNames;
    private final List<Expr> columnMappingList;
    private Map<String, Pair<String, List<String>>> columnToFunction;
    private Map<String, Expr> parsedExprMap;

    public LoadColumnsInfo(List<String> columnNames, List<Expr> columnMappingList) {
        this.columnNames = columnNames;
        this.columnMappingList = columnMappingList;
    }

    public Map<String, Expr> getParsedExprMap() {
        return this.parsedExprMap;
    }

    @Override
    public void analyze(Analyzer analyzer) throws AnalysisException {
        this.checkColumnNames();
        this.checkColumnMapping();
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("COLUMNS ( ");
        sb.append(Joiner.on((String)",").join(this.columnNames));
        sb.append(")");
        if (this.columnMappingList != null || this.columnMappingList.size() != 0) {
            sb.append(" SET (");
            sb.append(Joiner.on((String)",").join((Iterable)this.columnMappingList.parallelStream().map(entity -> entity.toSql()).collect(Collectors.toList())));
            sb.append(")");
        }
        return sb.toString();
    }

    private void checkColumnNames() throws AnalysisException {
        if (this.columnNames == null || this.columnNames.isEmpty()) {
            return;
        }
        TreeSet columnSet = Sets.newTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER);
        for (String col : this.columnNames) {
            if (columnSet.add(col)) continue;
            ErrorReport.reportAnalysisException(ErrorCode.ERR_DUP_FIELDNAME, col);
        }
    }

    private void checkColumnMapping() throws AnalysisException {
        if (this.columnMappingList == null || this.columnMappingList.isEmpty()) {
            return;
        }
        this.columnToFunction = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        this.parsedExprMap = Maps.newHashMap();
        for (Expr expr : this.columnMappingList) {
            if (!(expr instanceof BinaryPredicate)) {
                throw new AnalysisException("Mapping function should only be binary predicate: " + expr.toSql());
            }
            BinaryPredicate predicate = (BinaryPredicate)expr;
            if (predicate.getOp() != BinaryPredicate.Operator.EQ) {
                throw new AnalysisException("Mapping function should only be binary predicate with EQ operator: " + (Object)((Object)predicate.getOp()));
            }
            Expr child0 = (Expr)predicate.getChild(0);
            if (!(child0 instanceof SlotRef)) {
                throw new AnalysisException("Mapping function's left child should be a column name: " + child0.toSql());
            }
            String column = ((SlotRef)child0).getColumnName();
            if (this.columnToFunction.containsKey(column)) {
                throw new AnalysisException("Duplicate mapping for column: " + column);
            }
            Expr child1 = (Expr)predicate.getChild(1);
            if (!(child1 instanceof FunctionCallExpr)) {
                throw new AnalysisException("Mapping function's right child should be a function: " + child1.toSql());
            }
            if (!child1.supportSerializable()) {
                throw new AnalysisException("Expr do not support serializable." + child1.toSql());
            }
            this.parsedExprMap.put(column, child1);
            FunctionCallExpr functionCallExpr = (FunctionCallExpr)child1;
            String functionName = functionCallExpr.getFnName().getFunction();
            List<Expr> paramExprs = functionCallExpr.getParams().exprs();
            ArrayList args = Lists.newArrayList();
            for (Expr paramExpr : paramExprs) {
                if (paramExpr instanceof SlotRef) {
                    SlotRef slot = (SlotRef)paramExpr;
                    args.add(slot.getColumnName());
                    continue;
                }
                if (paramExpr instanceof StringLiteral) {
                    StringLiteral literal = (StringLiteral)paramExpr;
                    args.add(literal.getValue());
                    continue;
                }
                if (paramExpr instanceof NullLiteral) {
                    args.add(null);
                    continue;
                }
                throw new AnalysisException("Mapping function args error, arg: " + paramExpr.toSql());
            }
            Pair<String, ArrayList> functionPair = new Pair<String, ArrayList>(functionName, args);
            this.columnToFunction.put(column, functionPair);
        }
    }
}

