/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.DateLiteral;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LargeIntLiteral;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.NotImplementedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class LiteralExpr
extends Expr
implements Comparable<LiteralExpr> {
    private static final Logger LOG = LogManager.getLogger(LiteralExpr.class);

    public LiteralExpr() {
        this.numDistinctValues = 1L;
    }

    protected LiteralExpr(LiteralExpr other) {
        super(other);
    }

    public static LiteralExpr create(String value, Type type) throws AnalysisException {
        Preconditions.checkArgument((!type.equals(Type.INVALID) ? 1 : 0) != 0);
        LiteralExpr literalExpr = null;
        switch (type.getPrimitiveType()) {
            case NULL_TYPE: {
                literalExpr = new NullLiteral();
                break;
            }
            case BOOLEAN: {
                literalExpr = new BoolLiteral(value);
                break;
            }
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                literalExpr = new IntLiteral(value, type);
                break;
            }
            case LARGEINT: {
                literalExpr = new LargeIntLiteral(value);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                literalExpr = new FloatLiteral(value);
                break;
            }
            case DECIMALV2: {
                literalExpr = new DecimalLiteral(value);
                break;
            }
            case CHAR: 
            case VARCHAR: 
            case HLL: 
            case STRING: {
                literalExpr = new StringLiteral(value);
                literalExpr.setType(type);
                break;
            }
            case DATE: 
            case DATETIME: {
                literalExpr = new DateLiteral(value, type);
                break;
            }
            default: {
                throw new AnalysisException("Type[" + type.toSql() + "] not supported.");
            }
        }
        Preconditions.checkNotNull((Object)literalExpr);
        return literalExpr;
    }

    public static LiteralExpr init(LiteralExpr expr) throws AnalysisException {
        Preconditions.checkArgument((boolean)expr.getType().equals(Type.INVALID));
        String value = expr.getStringValue();
        LiteralExpr literalExpr = null;
        if (expr instanceof NullLiteral) {
            literalExpr = new NullLiteral();
        } else if (expr instanceof BoolLiteral) {
            literalExpr = new BoolLiteral(value);
        } else if (expr instanceof IntLiteral) {
            literalExpr = new IntLiteral(Long.parseLong(value));
        } else if (expr instanceof LargeIntLiteral) {
            literalExpr = new LargeIntLiteral(value);
        } else if (expr instanceof FloatLiteral) {
            literalExpr = new FloatLiteral(value);
        } else if (expr instanceof DecimalLiteral) {
            literalExpr = new DecimalLiteral(value);
        } else if (expr instanceof StringLiteral) {
            literalExpr = new StringLiteral(value);
        } else if (expr instanceof DateLiteral) {
            literalExpr = new DateLiteral(value, expr.getType());
        } else {
            throw new AnalysisException("Type[" + expr.getType().toSql() + "] not supported.");
        }
        Preconditions.checkNotNull((Object)literalExpr);
        return literalExpr;
    }

    public static LiteralExpr createInfinity(Type type, boolean isMax) throws AnalysisException {
        Preconditions.checkArgument((!type.equals(Type.INVALID) ? 1 : 0) != 0);
        if (isMax) {
            return MaxLiteral.MAX_VALUE;
        }
        switch (type.getPrimitiveType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return IntLiteral.createMinValue(type);
            }
            case LARGEINT: {
                return LargeIntLiteral.createMinValue();
            }
            case DATE: 
            case DATETIME: {
                return DateLiteral.createMinValue(type);
            }
        }
        throw new AnalysisException("Invalid data type for creating infinity: " + type);
    }

    @Override
    protected void analyzeImpl(Analyzer analyzer) throws AnalysisException {
    }

    public Object getRealValue() {
        Preconditions.checkState((boolean)false, (Object)("should implement this in derived class. " + this.type.toSql()));
        return null;
    }

    public abstract boolean isMinValue();

    public abstract int compareLiteral(LiteralExpr var1);

    @Override
    public int compareTo(LiteralExpr literalExpr) {
        return this.compareLiteral(literalExpr);
    }

    @Override
    public String getStringValue() {
        return null;
    }

    public long getLongValue() {
        return 0L;
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public ByteBuffer getHashValue(PrimitiveType type) {
        ByteBuffer buffer;
        String value = this.getStringValue();
        try {
            buffer = ByteBuffer.wrap(value.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return buffer;
    }

    public void swapSign() throws NotImplementedException {
        throw new NotImplementedException("swapSign() only implemented for numericliterals");
    }

    @Override
    public boolean supportSerializable() {
        return true;
    }

    @Override
    public void write(DataOutput out) throws IOException {
    }

    @Override
    public void readFields(DataInput in) throws IOException {
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LiteralExpr)) {
            return false;
        }
        if (obj instanceof StringLiteral && !(this instanceof StringLiteral) || this instanceof StringLiteral && !(obj instanceof StringLiteral) || obj instanceof DecimalLiteral && !(this instanceof DecimalLiteral) || this instanceof DecimalLiteral && !(obj instanceof DecimalLiteral)) {
            return false;
        }
        return this.compareLiteral((LiteralExpr)obj) == 0;
    }

    @Override
    public boolean isNullable() {
        return this instanceof NullLiteral;
    }
}

