/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.analysis.PartitionDesc;
import org.apache.doris.analysis.PartitionKeyDesc;
import org.apache.doris.analysis.SinglePartitionDesc;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.ListPartitionInfo;
import org.apache.doris.catalog.PartitionInfo;
import org.apache.doris.catalog.PartitionType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;

public class ListPartitionDesc
extends PartitionDesc {
    public ListPartitionDesc(List<String> partitionColNames, List<SinglePartitionDesc> singlePartitionDescs) {
        super(partitionColNames, singlePartitionDescs);
        this.type = PartitionType.LIST;
    }

    @Override
    public void checkPartitionKeyValueType(PartitionKeyDesc partitionKeyDesc) throws AnalysisException {
        if (partitionKeyDesc.getPartitionType() != PartitionKeyDesc.PartitionKeyValueType.IN) {
            throw new AnalysisException("You can only use in values to create list partitions");
        }
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("PARTITION BY LIST(");
        int idx = 0;
        for (String column : this.partitionColNames) {
            if (idx != 0) {
                sb.append(", ");
            }
            sb.append("`").append(column).append("`");
            ++idx;
        }
        sb.append(")\n(\n");
        for (int i = 0; i < this.singlePartitionDescs.size(); ++i) {
            if (i != 0) {
                sb.append(",\n");
            }
            sb.append(((SinglePartitionDesc)this.singlePartitionDescs.get(i)).toSql());
        }
        sb.append("\n)");
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public PartitionInfo toPartitionInfo(List<Column> schema, Map<String, Long> partitionNameToId, boolean isTemp) throws DdlException {
        ArrayList<Column> partitionColumns = new ArrayList<Column>();
        for (String colName : this.partitionColNames) {
            boolean find = false;
            for (Column column : schema) {
                if (!column.getName().equalsIgnoreCase(colName)) continue;
                try {
                    ListPartitionInfo.checkPartitionColumn(column);
                }
                catch (AnalysisException e) {
                    throw new DdlException(e.getMessage());
                }
                partitionColumns.add(column);
                find = true;
                break;
            }
            if (find) continue;
            throw new DdlException("Partition column[" + colName + "] does not found");
        }
        ListPartitionInfo listPartitionInfo = new ListPartitionInfo(partitionColumns);
        for (SinglePartitionDesc desc : this.singlePartitionDescs) {
            long partitionId = partitionNameToId.get(desc.getPartitionName());
            listPartitionInfo.handleNewSinglePartitionDesc(desc, partitionId, isTemp);
        }
        return listPartitionInfo;
    }
}

