/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;

public class LimitElement {
    public static LimitElement NO_LIMIT = new LimitElement();
    private long limit;
    private long offset;

    public LimitElement() {
        this.limit = -1L;
        this.offset = 0L;
    }

    public LimitElement(long limit) {
        this.limit = limit;
        this.offset = 0L;
    }

    public LimitElement(long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    protected LimitElement(LimitElement other) {
        this.limit = other.limit;
        this.offset = other.offset;
    }

    public LimitElement clone() {
        return new LimitElement(this);
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean hasLimit() {
        return this.limit != -1L;
    }

    public long getOffset() {
        return this.offset;
    }

    public boolean hasOffset() {
        return this.offset != 0L;
    }

    public String toSql() {
        if (this.limit == -1L) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" LIMIT ");
        if (this.offset != 0L) {
            sb.append(this.offset + ", ");
        }
        sb.append("" + this.limit);
        return sb.toString();
    }

    public void analyze(Analyzer analyzer) {
        if (this.limit == 0L) {
            analyzer.setHasEmptyResultSet();
        }
    }

    public void reset() {
    }
}

