/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.Predicate;
import org.apache.doris.analysis.StringLiteral;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSet;
import org.apache.doris.catalog.ScalarFunction;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;

public class LikePredicate
extends Predicate {
    private final Operator op;

    public static void initBuiltins(FunctionSet functionSet) {
        functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltin(Operator.LIKE.name(), Type.BOOLEAN, Lists.newArrayList((Object[])new Type[]{Type.VARCHAR, Type.VARCHAR}), false, "_ZN5doris13LikePredicate4likeEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", "_ZN5doris13LikePredicate12like_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13LikePredicate10like_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", true));
        functionSet.addBuiltinBothScalaAndVectorized(ScalarFunction.createBuiltin(Operator.REGEXP.name(), Type.BOOLEAN, Lists.newArrayList((Object[])new Type[]{Type.VARCHAR, Type.VARCHAR}), false, "_ZN5doris13LikePredicate5regexEPN9doris_udf15FunctionContextERKNS1_9StringValES6_", "_ZN5doris13LikePredicate13regex_prepareEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", "_ZN5doris13LikePredicate11regex_closeEPN9doris_udf15FunctionContextENS2_18FunctionStateScopeE", true));
    }

    public LikePredicate(Operator op, Expr e1, Expr e2) {
        this.op = op;
        Preconditions.checkNotNull((Object)e1);
        this.children.add(e1);
        Preconditions.checkNotNull((Object)e2);
        this.children.add(e2);
        this.selectivity = 0.1;
    }

    protected LikePredicate(LikePredicate other) {
        super(other);
        this.op = other.op;
    }

    @Override
    public Expr clone() {
        return new LikePredicate(this);
    }

    public Operator getOp() {
        return this.op;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        return ((LikePredicate)obj).op == this.op;
    }

    @Override
    public String toSqlImpl() {
        return ((Expr)this.getChild(0)).toSql() + " " + this.op.toString() + " " + ((Expr)this.getChild(1)).toSql();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.FUNCTION_CALL;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        super.analyzeImpl(analyzer);
        if (((Expr)this.getChild(0)).getType().isObjectStored()) {
            throw new AnalysisException("left operand of " + this.op.toString() + " must not be Bitmap or HLL: " + this.toSql());
        }
        if (!((Expr)this.getChild(1)).getType().isStringType() && !((Expr)this.getChild(1)).getType().isNull()) {
            throw new AnalysisException("right operand of " + this.op.toString() + " must be of type STRING: " + this.toSql());
        }
        if (!((Expr)this.getChild(0)).getType().isStringType()) {
            this.uncheckedCastChild(Type.VARCHAR, 0);
        }
        this.fn = this.getBuiltinFunction(analyzer, this.op.toString(), this.collectChildReturnTypes(), Function.CompareMode.IS_NONSTRICT_SUPERTYPE_OF);
        if (!((Expr)this.getChild(1)).getType().isNull() && ((Expr)this.getChild(1)).isLiteral() && this.op == Operator.REGEXP) {
            try {
                Pattern.compile(((StringLiteral)this.getChild(1)).getValue());
            }
            catch (PatternSyntaxException e) {
                throw new AnalysisException("Invalid regular expression in '" + this.toSql() + "'");
            }
        }
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode((Object)this.op);
    }

    public static enum Operator {
        LIKE("LIKE"),
        REGEXP("REGEXP");

        private final String description;

        private Operator(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

