/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.AnalyticExpr;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.GroupingFunctionCallExpr;
import org.apache.doris.analysis.InlineViewRef;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.Subquery;
import org.apache.doris.analysis.TableName;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.InlineView;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.UserException;

public class LateralViewRef
extends TableRef {
    private Expr expr;
    private String viewName;
    private String columnName;
    private TableRef relatedTableRef;
    private FunctionCallExpr fnExpr;
    private List<SlotRef> originSlotRefList = Lists.newArrayList();
    private InlineView view;
    private SlotRef explodeSlotRef;

    public LateralViewRef(Expr expr, String viewName, String columnName) {
        super(null, viewName);
        this.expr = expr;
        this.viewName = viewName;
        this.columnName = columnName;
    }

    public void setRelatedTable(TableRef relatedTableRef) {
        this.relatedTableRef = relatedTableRef;
    }

    public FunctionCallExpr getFnExpr() {
        return this.fnExpr;
    }

    @Override
    public void analyze(Analyzer analyzer) throws UserException {
        if (this.isAnalyzed) {
            return;
        }
        Preconditions.checkNotNull((Object)this.relatedTableRef);
        if (!(this.expr instanceof FunctionCallExpr)) {
            throw new AnalysisException("Only support function call expr in lateral view");
        }
        this.analyzeFunctionExpr(analyzer);
        this.desc = analyzer.registerTableRef(this);
        this.explodeSlotRef = new SlotRef(new TableName(null, this.viewName), this.columnName);
        this.explodeSlotRef.analyze(analyzer);
        this.isAnalyzed = true;
    }

    @Override
    public TableRef clone() {
        return new LateralViewRef(this.expr.clone(), this.viewName, this.columnName);
    }

    private void analyzeFunctionExpr(Analyzer analyzer) throws AnalysisException {
        this.fnExpr = (FunctionCallExpr)this.expr;
        this.fnExpr.setTableFnCall(true);
        this.checkAndSupplyDefaultTableName(this.fnExpr);
        this.fnExpr.analyze(analyzer);
        for (Expr expr : this.fnExpr.getChildren()) {
            this.checkScalarFunction(expr);
        }
    }

    @Override
    public TupleDescriptor createTupleDescriptor(Analyzer analyzer) throws AnalysisException {
        ArrayList columnList = Lists.newArrayList();
        columnList.add(new Column(this.columnName, this.fnExpr.getFn().getReturnType(), false, null, true, null, ""));
        this.view = new InlineView(this.viewName, (List<Column>)columnList);
        TupleDescriptor result = analyzer.getDescTbl().createTupleDescriptor();
        result.setTable(this.view);
        return result;
    }

    public void materializeRequiredSlots(ExprSubstitutionMap baseTblSmap, Analyzer analyzer) throws AnalysisException {
        Expr substituteFnExpr = this.fnExpr;
        if (this.relatedTableRef instanceof InlineViewRef) {
            substituteFnExpr = this.fnExpr.trySubstitute(baseTblSmap, analyzer, false);
        }
        substituteFnExpr.collect(SlotRef.class, this.originSlotRefList);
        for (SlotRef originSlotRef : this.originSlotRefList) {
            originSlotRef.getDesc().setIsMaterialized(true);
        }
        this.explodeSlotRef.getDesc().setIsMaterialized(true);
    }

    private void checkAndSupplyDefaultTableName(FunctionCallExpr expr) throws AnalysisException {
        ArrayList slotRefList = Lists.newArrayList();
        expr.collect(SlotRef.class, slotRefList);
        TableName relatedTableName = this.relatedTableRef.getAliasAsName();
        for (SlotRef slotRef : slotRefList) {
            TableName tableName = slotRef.getOriginTableName();
            if (tableName == null) {
                slotRef.setTblName(relatedTableName.cloneWithoutAnalyze());
                continue;
            }
            if (tableName.getDb() == null && tableName.getTbl() != null) {
                if (Config.lower_case_table_names != 0) {
                    throw new AnalysisException("Not support specify table name in table function when config.lower_case_table_names is not 0");
                }
                if (tableName.getTbl().equals(relatedTableName.getTbl())) {
                    tableName.setDb(relatedTableName.getDb());
                    continue;
                }
                throw new AnalysisException("The column " + slotRef.toMySql() + " in lateral view must come from the origin table " + relatedTableName.toSql());
            }
            if (tableName.getDb().equalsIgnoreCase(relatedTableName.getDb())) continue;
            throw new AnalysisException("The column " + slotRef.toMySql() + " in lateral view must come from the origin table " + this.relatedTableRef.toSql());
        }
    }

    private void checkScalarFunction(Expr child0) throws AnalysisException {
        ArrayList groupingFunctionCallExprList = Lists.newArrayList();
        child0.collect(GroupingFunctionCallExpr.class, groupingFunctionCallExprList);
        if (!groupingFunctionCallExprList.isEmpty()) {
            throw new AnalysisException("Grouping function are not allowed in lateral view.");
        }
        if (child0.containsAggregate()) {
            throw new AnalysisException("Agg function are not allowed in lateral view.");
        }
        ArrayList analyticExprList = Lists.newArrayList();
        child0.collect(AnalyticExpr.class, analyticExprList);
        if (!analyticExprList.isEmpty()) {
            throw new AnalysisException("Analytic expr are not allowed in lateral view.");
        }
        ArrayList subqueryList = Lists.newArrayList();
        child0.collect(Subquery.class, subqueryList);
        if (!subqueryList.isEmpty()) {
            throw new AnalysisException("Subquery is not allowed in lateral view");
        }
    }

    @Override
    public String toSql() {
        return "lateral view " + this.fnExpr.toSql() + " " + this.viewName + " as " + this.columnName;
    }

    @Override
    public String toString() {
        return this.toSql();
    }

    @Override
    public void reset() {
        this.isAnalyzed = false;
        this.expr.reset();
        this.fnExpr = null;
        this.originSlotRefList = Lists.newArrayList();
        this.view = null;
        this.explodeSlotRef = null;
    }
}

