/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.DecimalLiteral;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FloatLiteral;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.analysis.MaxLiteral;
import org.apache.doris.analysis.NullLiteral;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.io.Text;
import org.apache.doris.thrift.TExprNode;
import org.apache.doris.thrift.TExprNodeType;
import org.apache.doris.thrift.TLargeIntLiteral;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LargeIntLiteral
extends LiteralExpr {
    private static final Logger LOG = LogManager.getLogger(LargeIntLiteral.class);
    public static final BigInteger LARGE_INT_MIN = new BigInteger("-170141183460469231731687303715884105728");
    public static final BigInteger LARGE_INT_MAX = new BigInteger("170141183460469231731687303715884105727");
    public static final BigInteger LARGE_INT_MAX_ABS = new BigInteger("170141183460469231731687303715884105728");
    private BigInteger value;

    public LargeIntLiteral() {
        this.analysisDone();
    }

    public LargeIntLiteral(boolean isMax) throws AnalysisException {
        this.type = Type.LARGEINT;
        this.value = isMax ? LARGE_INT_MAX : LARGE_INT_MIN;
        this.analysisDone();
    }

    public LargeIntLiteral(String value) throws AnalysisException {
        BigInteger bigInt;
        try {
            bigInt = new BigInteger(value);
            if (bigInt.compareTo(LARGE_INT_MIN) < 0 || bigInt.compareTo(LARGE_INT_MAX_ABS) > 0) {
                throw new AnalysisException("Large int literal is out of range: " + value);
            }
        }
        catch (NumberFormatException e) {
            throw new AnalysisException("Invalid integer literal: " + value, e);
        }
        this.value = bigInt;
        this.type = Type.LARGEINT;
        this.analysisDone();
    }

    protected LargeIntLiteral(LargeIntLiteral other) {
        super(other);
        this.value = other.value;
    }

    @Override
    public Expr clone() {
        return new LargeIntLiteral(this);
    }

    public static LargeIntLiteral createMinValue() {
        LargeIntLiteral largeIntLiteral = new LargeIntLiteral();
        largeIntLiteral.type = Type.LARGEINT;
        largeIntLiteral.value = LARGE_INT_MIN;
        return largeIntLiteral;
    }

    @Override
    public void analyzeImpl(Analyzer analyzer) throws AnalysisException {
        if (this.value.compareTo(LARGE_INT_MIN) < 0 || this.value.compareTo(LARGE_INT_MAX) > 0) {
            throw new AnalysisException("Number Overflow. literal: " + this.value);
        }
    }

    @Override
    public boolean isMinValue() {
        return this.value.compareTo(LARGE_INT_MIN) == 0;
    }

    @Override
    public Object getRealValue() {
        return this.value;
    }

    @Override
    public ByteBuffer getHashValue(PrimitiveType type) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byteArray = this.value.toByteArray();
        int len = byteArray.length;
        int end = 0;
        if (len > 16) {
            end = len - 16;
        }
        for (int i = len - 1; i >= end; --i) {
            buffer.put(byteArray[i]);
        }
        if (this.value.signum() >= 0) {
            while (len++ < 16) {
                buffer.put((byte)0);
            }
        } else {
            while (len++ < 16) {
                buffer.put((byte)-1);
            }
        }
        buffer.flip();
        return buffer;
    }

    @Override
    public int compareLiteral(LiteralExpr expr) {
        if (expr instanceof NullLiteral) {
            return 1;
        }
        if (expr == MaxLiteral.MAX_VALUE) {
            return -1;
        }
        if (expr.type.equals(Type.LARGEINT)) {
            return this.value.compareTo(((LargeIntLiteral)expr).value);
        }
        BigInteger intValue = new BigInteger(((IntLiteral)expr).getStringValue());
        return this.value.compareTo(intValue);
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public String toSqlImpl() {
        return this.getStringValue();
    }

    @Override
    protected void toThrift(TExprNode msg) {
        msg.node_type = TExprNodeType.LARGE_INT_LITERAL;
        msg.large_int_literal = new TLargeIntLiteral(this.value.toString());
    }

    @Override
    protected Expr uncheckedCastTo(Type targetType) throws AnalysisException {
        if (targetType.isFloatingPointType()) {
            return new FloatLiteral(new Double(this.value.doubleValue()), targetType);
        }
        if (targetType.isDecimalV2()) {
            return new DecimalLiteral(new BigDecimal(this.value));
        }
        if (targetType.isNumericType()) {
            try {
                return new IntLiteral(this.value.longValueExact(), targetType);
            }
            catch (ArithmeticException e) {
                throw new AnalysisException("Number out of range[" + this.value + "]. type: " + targetType);
            }
        }
        return super.uncheckedCastTo(targetType);
    }

    @Override
    public void swapSign() {
        this.value = this.value.negate();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.value.toString());
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.value = new BigInteger(Text.readString((DataInput)in));
    }

    public static LargeIntLiteral read(DataInput in) throws IOException {
        LargeIntLiteral largeIntLiteral = new LargeIntLiteral();
        largeIntLiteral.readFields(in);
        return largeIntLiteral;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.value);
    }
}

