/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.cluster.ClusterNamespace;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.ErrorCode;
import org.apache.doris.common.ErrorReport;
import org.apache.doris.common.FeNameFormat;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class LabelName
implements Writable {
    private String dbName;
    private String labelName;

    public LabelName() {
    }

    public LabelName(String dbName, String labelName) {
        this.dbName = dbName;
        this.labelName = labelName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public void analyze(Analyzer analyzer) throws AnalysisException {
        if (Strings.isNullOrEmpty((String)this.dbName)) {
            if (Strings.isNullOrEmpty((String)analyzer.getDefaultDb())) {
                ErrorReport.reportAnalysisException(ErrorCode.ERR_NO_DB_ERROR, new Object[0]);
            }
            this.dbName = analyzer.getDefaultDb();
        }
        this.dbName = ClusterNamespace.getFullName(analyzer.getClusterName(), this.dbName);
        FeNameFormat.checkLabel(this.labelName);
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (rhs instanceof LabelName) {
            LabelName rhsLabel = (LabelName)rhs;
            return this.dbName.equals(rhsLabel.dbName) && this.labelName.equals(rhsLabel.labelName);
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.dbName).append((Object)this.labelName).toHashCode();
    }

    public String toSql() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("`").append(this.dbName).append("`.`").append(this.labelName).append("`");
        return stringBuilder.toString();
    }

    public String toString() {
        return this.toSql();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.dbName);
        Text.writeString((DataOutput)out, (String)this.labelName);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbName = Text.readString((DataInput)in);
        this.labelName = Text.readString((DataInput)in);
    }
}

