/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.analysis;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.RedirectStatus;
import org.apache.doris.analysis.StatementBase;

public class KillStmt
extends StatementBase {
    private final boolean isConnectionKill;
    private final int connectionId;

    public KillStmt(boolean isConnectionKill, int connectionId) {
        this.isConnectionKill = isConnectionKill;
        this.connectionId = connectionId;
    }

    public boolean isConnectionKill() {
        return this.isConnectionKill;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void analyze(Analyzer analyzer) {
    }

    @Override
    public String toSql() {
        StringBuilder sb = new StringBuilder();
        sb.append("KILL ");
        if (!this.isConnectionKill) {
            sb.append("QUERY ");
        }
        sb.append(this.connectionId);
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    @Override
    public RedirectStatus getRedirectStatus() {
        return RedirectStatus.NO_FORWARD;
    }
}

